/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCustomEvent.h"

#include "CustomEvent.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCustomEvent);

/* Hash table */

static const HashTableValue JSCustomEventTableValues[3] =
{
    { "detail", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCustomEventDetail), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCustomEventConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCustomEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSCustomEventTableValues, 0 };
#else
    { 4, 3, JSCustomEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSCustomEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCustomEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCustomEventConstructorTableValues, 0 };
#else
    { 1, 0, JSCustomEventConstructorTableValues, 0 };
#endif

class JSCustomEventConstructor : public DOMConstructorObject {
public:
    JSCustomEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSCustomEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSCustomEventPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSCustomEventConstructor::s_info = { "CustomEventConstructor", 0, &JSCustomEventConstructorTable, 0 };

bool JSCustomEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCustomEventConstructor, DOMObject>(exec, &JSCustomEventConstructorTable, this, propertyName, slot);
}

bool JSCustomEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCustomEventConstructor, DOMObject>(exec, &JSCustomEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCustomEventPrototypeTableValues[2] =
{
    { "initCustomEvent", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsCustomEventPrototypeFunctionInitCustomEvent), (intptr_t)4 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCustomEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCustomEventPrototypeTableValues, 0 };
#else
    { 2, 1, JSCustomEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSCustomEventPrototype::s_info = { "CustomEventPrototype", 0, &JSCustomEventPrototypeTable, 0 };

JSObject* JSCustomEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCustomEvent>(exec, globalObject);
}

bool JSCustomEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCustomEventPrototypeTable, this, propertyName, slot);
}

bool JSCustomEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCustomEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSCustomEvent::s_info = { "CustomEvent", &JSEvent::s_info, &JSCustomEventTable, 0 };

JSCustomEvent::JSCustomEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<CustomEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

JSObject* JSCustomEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSCustomEventPrototype(JSCustomEventPrototype::createStructure(JSEventPrototype::self(exec, globalObject)));
}

bool JSCustomEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCustomEvent, Base>(exec, &JSCustomEventTable, this, propertyName, slot);
}

bool JSCustomEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCustomEvent, Base>(exec, &JSCustomEventTable, this, propertyName, descriptor);
}

JSValue jsCustomEventDetail(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCustomEvent* castedThis = static_cast<JSCustomEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CustomEvent* imp = static_cast<CustomEvent*>(castedThis->impl());
    JSValue result = imp->detail().jsValue();;
    return result;
}

JSValue jsCustomEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCustomEvent* domObject = static_cast<JSCustomEvent*>(asObject(slotBase));
    return JSCustomEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSCustomEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCustomEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsCustomEventPrototypeFunctionInitCustomEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSCustomEvent::s_info))
        return throwError(exec, TypeError);
    JSCustomEvent* castedThisObj = static_cast<JSCustomEvent*>(asObject(thisValue));
    CustomEvent* imp = static_cast<CustomEvent*>(castedThisObj->impl());
    const UString& typeArg = args.at(0).toString(exec);
    bool canBubbleArg = args.at(1).toBoolean(exec);
    bool cancelableArg = args.at(2).toBoolean(exec);
    ScriptValue detailArg = args.at(3);

    imp->initCustomEvent(typeArg, canBubbleArg, cancelableArg, detailArg);
    return jsUndefined();
}


}
