/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGGradientElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedEnumeration.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "SVGGradientElement.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGGradientElement);

/* Hash table */

static const HashTableValue JSSVGGradientElementTableValues[9] =
{
    { "gradientUnits", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementGradientUnits), (intptr_t)0 },
    { "gradientTransform", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementGradientTransform), (intptr_t)0 },
    { "spreadMethod", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSpreadMethod), (intptr_t)0 },
    { "href", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementHref), (intptr_t)0 },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementExternalResourcesRequired), (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementClassName), (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementStyle), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGGradientElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSSVGGradientElementTableValues, 0 };
#else
    { 16, 15, JSSVGGradientElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGGradientElementConstructorTableValues[5] =
{
    { "SVG_SPREADMETHOD_UNKNOWN", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_UNKNOWN), (intptr_t)0 },
    { "SVG_SPREADMETHOD_PAD", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_PAD), (intptr_t)0 },
    { "SVG_SPREADMETHOD_REFLECT", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_REFLECT), (intptr_t)0 },
    { "SVG_SPREADMETHOD_REPEAT", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_REPEAT), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGGradientElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSSVGGradientElementConstructorTableValues, 0 };
#else
    { 8, 7, JSSVGGradientElementConstructorTableValues, 0 };
#endif

class JSSVGGradientElementConstructor : public DOMConstructorObject {
public:
    JSSVGGradientElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGGradientElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGGradientElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGGradientElementConstructor::s_info = { "SVGGradientElementConstructor", 0, &JSSVGGradientElementConstructorTable, 0 };

bool JSSVGGradientElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGGradientElementConstructor, DOMObject>(exec, &JSSVGGradientElementConstructorTable, this, propertyName, slot);
}

bool JSSVGGradientElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGGradientElementConstructor, DOMObject>(exec, &JSSVGGradientElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGGradientElementPrototypeTableValues[6] =
{
    { "SVG_SPREADMETHOD_UNKNOWN", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_UNKNOWN), (intptr_t)0 },
    { "SVG_SPREADMETHOD_PAD", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_PAD), (intptr_t)0 },
    { "SVG_SPREADMETHOD_REFLECT", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_REFLECT), (intptr_t)0 },
    { "SVG_SPREADMETHOD_REPEAT", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGradientElementSVG_SPREADMETHOD_REPEAT), (intptr_t)0 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGGradientElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGGradientElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGGradientElementPrototypeTableValues, 0 };
#else
    { 17, 15, JSSVGGradientElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGGradientElementPrototype::s_info = { "SVGGradientElementPrototype", 0, &JSSVGGradientElementPrototypeTable, 0 };

JSObject* JSSVGGradientElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGGradientElement>(exec, globalObject);
}

bool JSSVGGradientElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSSVGGradientElementPrototype, JSObject>(exec, &JSSVGGradientElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGGradientElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSSVGGradientElementPrototype, JSObject>(exec, &JSSVGGradientElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGGradientElement::s_info = { "SVGGradientElement", &JSSVGElement::s_info, &JSSVGGradientElementTable, 0 };

JSSVGGradientElement::JSSVGGradientElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGGradientElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGGradientElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGGradientElementPrototype(JSSVGGradientElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGGradientElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGGradientElement, Base>(exec, &JSSVGGradientElementTable, this, propertyName, slot);
}

bool JSSVGGradientElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGGradientElement, Base>(exec, &JSSVGGradientElementTable, this, propertyName, descriptor);
}

JSValue jsSVGGradientElementGradientUnits(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->gradientUnitsAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGGradientElementGradientTransform(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->gradientTransformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGGradientElementSpreadMethod(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedEnumeration> obj = imp->spreadMethodAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGGradientElementHref(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGGradientElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGGradientElementClassName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGGradientElementStyle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* castedThis = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
    return result;
}

JSValue jsSVGGradientElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGradientElement* domObject = static_cast<JSSVGGradientElement*>(asObject(slotBase));
    return JSSVGGradientElement::getConstructor(exec, domObject->globalObject());
}
JSValue JSSVGGradientElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGGradientElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsSVGGradientElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGGradientElement::s_info))
        return throwError(exec, TypeError);
    JSSVGGradientElement* castedThisObj = static_cast<JSSVGGradientElement*>(asObject(thisValue));
    SVGGradientElement* imp = static_cast<SVGGradientElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

// Constant getters

JSValue jsSVGGradientElementSVG_SPREADMETHOD_UNKNOWN(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(0));
}

JSValue jsSVGGradientElementSVG_SPREADMETHOD_PAD(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(1));
}

JSValue jsSVGGradientElementSVG_SPREADMETHOD_REFLECT(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(2));
}

JSValue jsSVGGradientElementSVG_SPREADMETHOD_REPEAT(ExecState* exec, JSValue, const Identifier&)
{
    return jsNumber(exec, static_cast<int>(3));
}


}

#endif // ENABLE(SVG)
