#ifndef PLAYLIST_H
#define PLAYLIST_H
#include "trackcollection.h"


namespace Spotify
{
    class Link;
    class User;
    class Session;
    //playlist offline status enum type
    enum ePlaylistOfflineStatus
    {
        Unavailable = 0,
        Available,
        Downloading,
        Waiting
    };

    class Playlist: public TrackCollection
    {
        Q_OBJECT

    public:
        Playlist(sp_session* session, sp_playlist* playlist = 0, QObject* parent = 0 );
        ~Playlist();

        QString getName() const { return m_name; }
        Spotify::User* getOwner() const { return m_owner; }
        bool isCollaborative() const { return m_collaborative; }
        sp_playlist* getPlaylist() const { return m_playlist; }
        virtual bool load();
        void setPosition(int pos);
        int getPosition();
        int getNumTracks();
        ePlaylistOfflineStatus getOfflineStatus();

    signals:

        void updated(); //playlist state updated

    private:

        sp_session* m_session;
        sp_playlist_callbacks* m_callbacks; //playlist callbacks (i.e., for notifications about state change such as tracks added / removed)
        sp_playlist* m_playlist;
        int m_position;
        QString m_name;
        int m_numTracks;
        bool m_isOffline;
        Spotify::User* m_owner;
        bool m_collaborative;
        ePlaylistOfflineStatus m_offlineStatus;

        /* slots invoked by the corresponding playlist callbacks */

    private slots:

        void tracksAdded(sp_track** tracks, qint32 num_tracks, qint32 position);
        void tracksRemoved(qint32* tracks, qint32 num_tracks);
        void playlistRenamed();
        void playlistStateChanged();
        void playlistUpdateInProgress( qint32 done );
        void playlistMetadataUpdated();

        void tracksMovedWrapper( sp_playlist* pl, const int* tracks, int num_tracks, int new_position,
                                 void* userdata );
    };
} // namespace Spotify

#endif // PLAYLIST_H
