#ifndef ALBUMBROWSER_H
#define ALBUMBROWSER_H
#include "trackcollection.h"

namespace Spotify
{

    class AlbumBrowser : public Spotify::TrackCollection
    {
        public:
            AlbumBrowser(sp_session* session, sp_albumbrowse* ab, QObject* parent = 0 );
            sp_albumbrowse* getAlbumBrowser() const { return m_albumBrowser; }
            Spotify::Album* getAlbum() { return m_album; }
            Spotify::Artist* getArtist() { return m_artist; }

            int getNumCopyrights() const { return m_copyrights.count(); }
            QList< QString > getCopyrights() const { return m_copyrights; }

            QString getReview() const { return m_review; }
            virtual bool load();

            void sortByDiscIndex(); //sort album tracks by disc (album) position index

            ~AlbumBrowser();

        private:
            sp_session* m_session;
            sp_albumbrowse* m_albumBrowser;
            Spotify::Album* m_album;
            Spotify::Artist* m_artist;
            QList< QString > m_copyrights;
            QString m_review;

    };

} // namespace Spotify

#endif // ALBUMBROWSER_H
