#ifndef PLAYLIST_H
#define PLAYLIST_H
#include "trackcollection.h"

namespace Spotify
{
    class Link;
    class User;
    class Session;
    class Playlist: public TrackCollection
    {
        Q_OBJECT

        public:
        Playlist(sp_session* session, sp_playlist* playlist = 0, QObject* parent = 0 );
            ~Playlist();

            QString getName() const { return m_name; }
            Spotify::User* getOwner() const { return m_owner; }
            bool isCollaborative() const { return m_collaborative; }
            sp_playlist* getPlaylist() const { return m_playlist; }
            virtual bool load();

            void updateName();
            void updateState();

            void setPosition(int pos);
            int getPosition();

            int getNumTracks();

        signals:
            void renamed();
            void stateChanged();

        private:
            sp_session* m_session;
            sp_playlist* m_playlist;
            int m_position;
            QString m_name;
            int m_numTracks;
            Spotify::User* m_owner;
            bool m_collaborative;
    };
} // namespace Spotify

#endif // PLAYLIST_H
