//Banner.cpp: Implementation of the Banner (Maemo5 / Hildon style) class.

#include "Banner.h"

Banner::Banner(QWidget *parent)
    : QDialog(parent)
{
    //default constructor
    setAttribute(Qt::WA_X11NetWmWindowTypeNotification);
    setAttribute(Qt::WA_ShowWithoutActivating);
    setFocusPolicy(Qt::NoFocus);
    setFixedWidth(QApplication::desktop()->screenGeometry().width()); //fix to desktop width
    setStyleSheet("QDialog { background: #FFFF66 }");

    m_pLabel = NULL;

    setLayout(&m_Layout);
}

Banner::~Banner()
{
}

void Banner::addLabelWidget(QLabel *label)
{
    //add label widget to internal layout
    if(m_pLabel)
        delete m_pLabel;

    m_pLabel = label;

    m_Layout.addWidget(label,0,Qt::AlignCenter); //center text area
}

void Banner::information(QWidget* parent, const QString& msg, qint32 timeout)
{
    Banner* banner = new Banner(parent);
    if(banner)
    {
        banner->setAttribute(Qt::WA_DeleteOnClose); //delete instance when closed
        QLabel* label = new QLabel();
        label->setStyleSheet("QLabel { color : black }");
        label->setText(msg);
        label->setWordWrap(true);
        banner->addLabelWidget(label);
        banner->show(); //call base
        if(timeout>0)
            banner->activateTimeout(timeout);
    }
}

void Banner::activateTimeout(qint32 timeout)
{
    //activate notification timeout
    QTimer::singleShot(timeout,this,SLOT(OnTimeout()));
}

void Banner::OnTimeout()
{
    //triggered when notification timeout has elapsed (hide notification)
    close(); //close notification on timeout
}
