#ifndef LOGINDIALOG_H
#define LOGINDIALOG_H

#include <QtGui/QDialog>
#include <QDesktopWidget>
#include <QtGui/QGridLayout>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QPushButton>
#include <QtGui/QMessageBox>
#include <QtGui/QCheckBox>
#include <QtGui/QComboBox>
#include <QStringListModel>
#include <QMaemo5ListPickSelector>
#include <QMaemo5ValueButton>
#include <QDebug>
#include <QSettings>
#include <qspotify_src/spotifysession.h>
#include "global_defs.h"

//misc. defines

#define IDX_BITRATE_96k 0
#define IDX_BITRATE_160k 1
#define IDX_BITRATE_320k 2


class LoginDialog : public QDialog
{
    Q_OBJECT

public:
    LoginDialog(Spotify::Session* pSession, QSettings* pSettings, QWidget *parent = 0);
    ~LoginDialog();

    void resetState();

private:

    QGridLayout m_Layout;

    Spotify::Session* m_pSession; //pointer to Spotify session instance
    sp_bitrate m_selectedBitrate; //prefered (selected) bitrate passed to the Spotify session instance

    QLabel m_UserIDText;
    QLineEdit m_UserIDInput;
    QLabel m_PasswordText;
    QLineEdit m_PasswordInput;

    QCheckBox m_SaveCredentials;

    QStringList m_bitrateList; //list of bitrate alternatives

    QMaemo5ValueButton m_PreferredBitrate;

    QPushButton m_LoginBtn;

    QSettings* m_pAppSettings; //pointer to app settings instance

    bool m_bSessionInit; //TRUE if session has been initialised

private slots:

    void OnLogin();
    void OnLoggedIn(Spotify::Error);
    void bitrateSelectionChanged(const QString& selection);
    void OnOrientationChanged(); //device orientation changed (e.g, screen rotate)

};

#endif // LOGINDIALOG_H
