#ifndef LOGINDIALOG_H
#define LOGINDIALOG_H

#include <QtGui/QDialog>
#include <QtGui/QGridLayout>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QPushButton>
#include <QtGui/QMessageBox>
#include <QtGui/QCheckBox>
#include <QSettings>
#include <qspotify_src/spotifysession.h>

class LoginDialog : public QDialog
{
    Q_OBJECT

public:
    LoginDialog(Spotify::Session* pSession, QSettings* pSettings, QWidget *parent = 0);
    ~LoginDialog();

    void resetState();


private:

    QGridLayout m_Layout;

    Spotify::Session* m_pSession; //pointer to Spotify session instance

    QLabel m_UserIDText;
    QLineEdit m_UserIDInput;
    QLabel m_PasswordText;
    QLineEdit m_PasswordInput;

    QCheckBox m_SaveCredentials;
    QPushButton m_LoginBtn;

    QSettings* m_pAppSettings; //pointer to app settings instance

    bool m_bSessionInit; //TRUE if session has been initialises

private slots:

    void OnLogin();
    void OnLoggedIn(Spotify::Error);

};

#endif // LOGINDIALOG_H
