//QueueView.h: Header file for the QueueView class (implements the queue  / Now Playing view)
#ifndef QUEUEVIEW_H
#define QUEUEVIEW_H

#include <QtGui/QWidget>
#include <QtGui/QLabel>
#include <QtGui/QPushButton>
#include <QtGui/QImage>
#include <QtGui/QBitmap>
#include <QtGui/QMainWindow>
#include <QtGui/QGridLayout>
#include <QtGui/QVBoxLayout>
#include <QtGui/QListWidget>
#include <QtGui/QListWidgetItem>
#include <QDebug>
#include <QScrollBar>
#include <QTextStream>
#include <QtGui/QPixmap>
#include <QMaemo5InformationBox>
#include <qspotify_src/spotifysession.h>
#include "CustomSlider.h"
#include "SpectrumAnalyzer.h"

class QueueView : public QMainWindow
{
    Q_OBJECT

public:

    QueueView(Spotify::Session* pSession, QWidget* parent = 0); //constructor
    ~QueueView();

    void setNowPlaying(QList<Spotify::Track*> queue, int currQueuePos, bool playing, qint64 currPlaybackPos = 0, qint64 currBufPos = 0);

private:

    QWidget m_MainLayout;

    QWidget m_BottomArea;

    QGridLayout m_GridLayout;

    QVBoxLayout m_AlbumLayout;
    QGridLayout m_PlayControls;

    QLabel m_AlbumCoverContainer;

    QLabel m_ArtistName;

    QImage m_AlbumCoverPic; //current album cover (for selected track)

    QPushButton m_PauseResumeBtn; //pause / resume

    QPushButton m_PrevBtn; //prev track

    QPushButton m_NextBtn; //next track

    CustomSlider* m_pProgressSlider; //track progress indicator / slider

    SpectrumAnalyzer* m_pSpectrum; //spectrum (active during audio playback)

    QListWidget m_TrackInfo;

    Spotify::Session* m_pSession; //Spotify session instance

    Spotify::Track* m_pCurrTrack; //currently playing track in queue

    qint32 m_currQueuePos; //current position in play queue

    qint32 m_currTrackDuration; //current track duration (in secs)

    QList<Spotify::Track*> m_PlayQueue; //current play queue

    void addTracks(QList<Spotify::Track*> trackList); //add tracks from specified tracklist to main listview

    void loadTrackData(Spotify::Track* track); //load data for specified track, e.g., album cover art

private slots:

    void OnTrackActivated(QListWidgetItem* currTrack);
    void OnPauseResumeToggle();
    void OnTrackPosUpdated(qint64 trackPos);
    void OnPlaybackPositionUpdated(qint64 trackPos);
    void OnAlbumCoverReady(QImage image);
    void OnTrackPlaybackFinished();
    void OnPlayingState(bool state);
    void OnNextTrackBtn();
    void OnPrevTrackBtn();

signals:

    void playQueuePosUpdated(qint32); //signal emitted when position in playqueue has been updated

};

#endif // QUEUEVIEW_H
