#ifndef COMMENTVIEW_H
#define COMMENTVIEW_H

#include <QMainWindow>

class RedditSession;
class RedditEntry;
class WebPreview;

class QUrl;
#include "redditsession.h"
namespace Ui {
    class CommentView;
}

class CommentView : public QMainWindow {
    Q_OBJECT
public:
    CommentView(RedditSession* ses, QWidget *parent = 0);
    ~CommentView();

    void setEntry(const RedditEntry& e);

protected:
    void changeEvent(QEvent *e);

private slots:
    void populate();
    void openBrowser();
    void openLink();
    void anchorClicked(const QUrl&);
private:
    Ui::CommentView *ui;
    RedditEntry m_entry;

    RedditSession* m_ses;
    WebPreview* m_web;
};

#endif // COMMENTVIEW_H
