#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "emittingbutton.h"
#include "settingsdialog.h"

#include <QMainWindow>

#include <QDebug>
#include <QFile>
#include <QInputDialog>
#include <QListWidgetItem>
#include <QMessageBox>
#include <QProcess>
#include <QRadioTuner>
#include <QSettings>
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusInterface>
#include <QTextStream>
#include <QTimer>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    Ui::MainWindow *ui;
    QRadioTuner *radio;
    QTimer *metaDataTimer;

    EmittingButton *quickAccessButton[4];

    QPoint listWidgetPosition;

    //Settings Variables
    QString fontName;
    int freqLabelFontSize;
    int rdsLabelsFontSize;
    int quickAccessButtonsFontSize;
    int buttonsFontSize;
    int stationListFontSize;

    int lastFreq;
    int currentSet;
    bool isFullScreen;
    QStringList quickAccessButtonsTextList;
    QStringList stationsList;

    void readSettings();
    void saveSettings();
    void populateListWidget();
    void setButtonsIcons();
    void createActionGroups();
    void createQuickAccessButtons();
    void setQuickAccessButtonsText();
    void changeFont();
    void startRadio();
    void stopRadio();
    void setWidgetsEnabled(bool);

private slots:
    void freqChanged(int);
    void getMetaData();
    void signalChanged();
    void settingsChanged();
    void quickAccessClicked(int);
    void quickAccessHold(int);
    void on_actionStart_Radio_triggered();
    void on_actionStop_Radio_triggered();
    void on_freqUpButton_clicked();
    void on_freqDownButton_clicked();
    void on_actionGetMetaData_triggered();
    void on_seekUpButton_clicked();
    void on_seekDownButton_clicked();
    void on_stationsListWidget_itemActivated(QListWidgetItem* item);
    void on_stationsListWidget_customContextMenuRequested(QPoint pos);

    void on_addStationButton_clicked();
    void on_actionToggle_Drag_Enabled_triggered();
    void on_volumeSlider_valueChanged(int value);
    void on_actionClear_List_triggered();
    void on_actionDelete_Station_triggered();
    void on_actionInsert_here_triggered();
    void on_prevStationButton_clicked();
    void on_nextStationButton_clicked();
    void on_actionSort_Alphabetically_triggered();
    void on_actionGetStereoMode_triggered();
    void on_actionSetForceStereoMode_triggered();
    void on_actionManual_triggered();
    void on_actionAbout_triggered();
    void on_actionGoFullScreen_triggered();
    void on_actionSpeakers_triggered();
    void on_actionHeadphones_triggered();
    void on_actionSettings_triggered();
    void on_actionAuto_Scan_triggered();

    void callIncoming();
};

#endif // MAINWINDOW_H
