#include "settingswidget.h"
#include <QLabel>
#include <QPushButton>
#include <QCheckBox>
#include <QComboBox>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QScrollArea>
#include <QSpinBox>
#include <QFontComboBox>
#include <QMainWindow>
#include <QInputDialog>

SettingsWidget::SettingsWidget(QWidget *parent, QString set1name, QString set2name,
                               QString set3name, bool landscapeOrient, QString Font,
                               int freqFontsize, int labelsFontSize, bool mono,
                               bool quickAccess, bool background) :  QMainWindow(parent)
{
    QLabel *set1Label = new QLabel("Rename set1");
    set1Label->setFixedWidth(200);
    set1Button = new QPushButton(set1name);
    connect(set1Button, SIGNAL(clicked()), SLOT(renameSet1Clicked()));

    QLabel *set2Label = new QLabel("Rename set2");
    set2Label->setFixedWidth(200);
    set2Button = new QPushButton(set2name);
    connect(set2Button, SIGNAL(clicked()), SLOT(renameSet2Clicked()));

    QLabel *set3Label = new QLabel("Rename set3");
    set3Label->setFixedWidth(200);
    set3Button = new QPushButton(set3name);
    connect(set3Button, SIGNAL(clicked()), SLOT(renameSet3Clicked()));

    QLabel *orientationLabel = new QLabel("Orientation");
    orientationLabel->setFixedWidth(200);
    orientationBox = new QComboBox;
    orientationBox->addItem(QIcon("/opt/filebox/icons/hicolor/orient_landscape.png"), "Landscape");
    orientationBox->setIconSize(QSize(48,48));
    orientationBox->addItem(QIcon("/opt/filebox/icons/hicolor/orient_portrait.png"), "Portrait");
    if (landscapeOrient) orientationBox->setCurrentIndex(0);
    else orientationBox->setCurrentIndex(1);

    monoRadioButton = new QCheckBox("Set Mono Mode");
    monoRadioButton->setChecked(mono);
    connect(monoRadioButton, SIGNAL(toggled(bool)), this, SIGNAL(monoModeChanged(bool)));

    quickAccessRadioButton = new QCheckBox("Show Quick Access Buttons");
    quickAccessRadioButton->setChecked(quickAccess);
    connect(quickAccessRadioButton, SIGNAL(toggled(bool)), this, SIGNAL(quickAccessChanged(bool)));

    showBackgroundBox = new QCheckBox("Show custom background");
    showBackgroundBox->setChecked(background);
    connect(showBackgroundBox, SIGNAL(toggled(bool)), this, SIGNAL(showBackgroundClicked(bool)));

    fontBox = new QFontComboBox;
    fontBox->setCurrentFont(Font);
    fontBox->setFontFilters(QFontComboBox::ScalableFonts);
    connect(fontBox, SIGNAL(currentFontChanged(QFont)), SLOT(fontBoxChanged()));
    freqSizeBox = new QSpinBox;
    freqSizeBox->setMinimum(40);
    freqSizeBox->setMaximum(200);
    freqSizeBox->setValue(freqFontsize);
    connect(freqSizeBox, SIGNAL(valueChanged(int)), SLOT(fontBoxChanged()));
    labelsSizeBox = new QSpinBox;
    labelsSizeBox->setMinimum(10);
    labelsSizeBox->setMaximum(50);
    labelsSizeBox->setValue(labelsFontSize);
    connect(labelsSizeBox, SIGNAL(valueChanged(int)), SLOT(fontBoxChanged()));



    QVBoxLayout *renameLabelsLayout = new QVBoxLayout;
    renameLabelsLayout->addWidget(set1Label);
    renameLabelsLayout->addWidget(set2Label);
    renameLabelsLayout->addWidget(set3Label);

    QVBoxLayout *renameButtonsLayout = new QVBoxLayout;
    renameButtonsLayout->addWidget(set1Button);
    renameButtonsLayout->addWidget(set2Button);
    renameButtonsLayout->addWidget(set3Button);

    QHBoxLayout *renameLayout = new QHBoxLayout;
    renameLayout->addLayout(renameLabelsLayout);
    renameLayout->addLayout(renameButtonsLayout);

    QHBoxLayout *orientationLayout = new QHBoxLayout;
    orientationLayout->addWidget(orientationLabel);
    orientationLayout->addWidget(orientationBox);

    QHBoxLayout *fontLayout = new QHBoxLayout;
    fontLayout->addWidget(fontBox);
    fontLayout->addWidget(freqSizeBox);
    fontLayout->addWidget(labelsSizeBox);


    QVBoxLayout *mainLayout = new QVBoxLayout;
    mainLayout->addLayout(renameLayout);
    mainLayout->addSpacing(20);
    //mainLayout->addLayout(orientationLayout);
    //mainLayout->addSpacing(20);
    mainLayout->addLayout(fontLayout);
    mainLayout->addSpacing(20);
    mainLayout->addWidget(showBackgroundBox);
    mainLayout->addWidget(monoRadioButton);
    mainLayout->addWidget(quickAccessRadioButton);
    mainLayout->addStretch();

    QWidget *widget = new QWidget;
    widget->setLayout(mainLayout);

    widget->setFixedWidth(790);

    QScrollArea *scrollArea=new QScrollArea;
    scrollArea->setWidget(widget);

    setCentralWidget(scrollArea);


}

void SettingsWidget::renameSet1Clicked()
{
    bool ok;
    QString nameTemp = QInputDialog::getText(this, "Sets Rename", "Insert Set1 Name:", QLineEdit::Normal, set1Button->text(), &ok , 0);
    if (ok)
    {
        set1Button->setText(nameTemp);
        emit set1NameChanged(nameTemp);

    }

}

void SettingsWidget::renameSet2Clicked()
{
    bool ok;
    QString nameTemp = QInputDialog::getText(this, "Sets Rename", "Insert Set2 Name:", QLineEdit::Normal, set2Button->text(), &ok , 0);
    if (ok)
    {
        set2Button->setText(nameTemp);
        emit set2NameChanged(nameTemp);

    }
}

void SettingsWidget::renameSet3Clicked()
{
    bool ok;
    QString nameTemp = QInputDialog::getText(this, "Sets Rename", "Insert Set3 Name:", QLineEdit::Normal, set3Button->text(), &ok , 0);
    if (ok)
    {
        set3Button->setText(nameTemp);
        emit set3NameChanged(nameTemp);

    }
}

void SettingsWidget::fontBoxChanged()
{
    emit fontChanged(fontBox->currentFont().toString(), freqSizeBox->value(), labelsSizeBox->value());
}
