#ifndef SETTINGSWIDGET_H
#define SETTINGSWIDGET_H

#include <QMainWindow>

class QPushButton;
class QCheckBox;
class QComboBox;
class QSpinBox;
class QFontComboBox;


class SettingsWidget : public QMainWindow
{
    Q_OBJECT
public:
    explicit SettingsWidget(QWidget *parent = 0,
                            QString set1name = "set1",
                            QString set2name = "set2",
                            QString set3name = "set3",
                            bool landscapeOrient = "true",
                            QString Font = "fontname",
                            int freqFontsize = 1,
                            int lablesFontSize = 1,
                            bool mono = false,
                            bool quickAccess = false);

signals:
    void set1NameChanged(QString);
    void set2NameChanged(QString);
    void set3NameChanged(QString);

    void quickAccessChanged(bool);

    void monoModeChanged(bool);

    void fontChanged(QString, int, int);

private:
    QPushButton *set1Button;
    QPushButton *set2Button;
    QPushButton *set3Button;

    QComboBox *orientationBox;

    QFontComboBox *fontBox;
    QSpinBox *freqSizeBox;
    QSpinBox *labelsSizeBox;

    QCheckBox *monoRadioButton;
    QCheckBox *quickAccessRadioButton;




public slots:
    void renameSet1Clicked();
    void renameSet2Clicked();
    void renameSet3Clicked();

    void fontBoxChanged();


};

#endif // SETTINGSWIDGET_H
