#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "radio.h"
#include "settingswidget.h"
#include "stationsdialog.h"
#include "managestations.h"

class QAction;
class QActionGroup;
class QString;
class QStringList;
class Radio;

class MainWindow : public QMainWindow
{
    Q_OBJECT

private:
    void createActions();
    void createMenu();
    void readSetsName();
    void saveSetsName();
    void readCurrentSet();
    void saveCurrentSet();
    void readSettings();
    void saveSettings();



    //Menu Actions
    QAction *set1Action;
    QAction *set2Action;
    QAction *set3Action;
    QAction *addStationAction;
    QAction *manageStationsAction;
    QAction *manualAction;
    QAction *stationsListAction;
    QAction *aboutAction;
    QAction *aboutQtAction;
    QAction *speakersAction;
    QAction *settingsAction;
    QActionGroup *setsActionGroup;

    //Settings Variables
    int currentSet;
    QString set1Name;
    QString set2Name;
    QString set3Name;
    bool showQuickAccess;
    bool landscapeOrientation;
    QString currentFont;
    int currentFreqFontSize;
    int currentLabelsFontSize;
    int currentIndex;
    bool fullScreen;
    bool monoMode;
    bool quickAccess;





public slots:
    //Menu actions slots
    void addStationTriggered();
    void set1ActionTriggered();
    void set2ActionTriggered();
    void set3ActionTriggered();
    void manualActionTriggered();
    void manageStationsActionTriggered();
    void about();
    void stationsListActionTriggered();
    void settingsActionTriggered();
    void goFullScreen();
    void aboutQt();
    void speakersActionTriggered();

    //Settings slots
    void changeSet1Name(QString);
    void changeSet2Name(QString);
    void changeSet3Name(QString);
    void quickAccessChanged(bool);
    void changeMonoMode(bool);
    void changeFont(QString, int, int);

    void listEdited(QStringList);

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();
    Radio *w;
    SettingsWidget *s;
    ManageStations *m;
    StationsDialog *d;
};

#endif // MAINWINDOW_H
