#include "mainwindow.h"
#include "radio.h"
#include "emittingbutton.h"
#include "fontdialog.h"
#include <QSettings>
#include <QStringList>
#include <QString>
#include <QAction>
#include <QActionGroup>
#include <QMenu>
#include <QMenuBar>
#include <QDialog>
#include <QInputDialog>
#include <QMessageBox>
#include <QApplication>
#include <QFontDialog>
#include <QScrollArea>
#include <QVBoxLayout>



MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{
    w = new Radio();
    b = new FontDialog(this);
    connect(b, SIGNAL(saveButtonClicked(QFont,int)), this, SLOT(changeFont(QFont,int)));

    setCentralWidget(w);

    loadSetsName();
    createActions();
    createMenu();
    loadCurrentSet();
    w->populateBox();
    w->loadCurrentIndex();





    setWindowTitle("QRadio");


}

MainWindow::~MainWindow()
{

}

void MainWindow::createActions()
{
    set1Action = new QAction(set1Name, this);
    set1Action->setCheckable(true);
    connect(set1Action, SIGNAL(triggered()), SLOT(set1ActionTriggered()));
    set2Action = new QAction(set2Name, this);
    set2Action->setCheckable(true);
    connect(set2Action, SIGNAL(triggered()), SLOT(set2ActionTriggered()));
    set3Action = new QAction(set3Name, this);
    set3Action->setCheckable(true);
    connect(set3Action, SIGNAL(triggered()), SLOT(set3ActionTriggered()));
    setsActionGroup = new QActionGroup(this);
    setsActionGroup->addAction(set1Action);
    setsActionGroup->addAction(set2Action);
    setsActionGroup->addAction(set3Action);
    addStationAction = new QAction(tr("Add Station"), this);
    connect(addStationAction, SIGNAL(triggered()), SLOT(addStationTriggered()));
    deleteStationAction = new QAction(tr("Delete Station"), this);
    connect(deleteStationAction, SIGNAL(triggered()), SLOT(deleteStationActionTriggered()));
    manualAction = new QAction(tr("Manual"), this);
    connect(manualAction, SIGNAL(triggered()), SLOT(manualActionTriggered()));
    renameSetsAction = new QAction(tr("Rename Sets"), this);
    connect(renameSetsAction, SIGNAL(triggered()), SLOT(renameSetsActionTriggered()));
    restartRadioAction = new QAction(tr("Restart Radio"), this);
    connect(restartRadioAction, SIGNAL(triggered()), w, SLOT(restartRadio()));
    changeFontAction = new QAction("Change Font", this);
    connect(changeFontAction, SIGNAL(triggered()), SLOT(changeFontActionTriggered()));
    forceMonoAction = new QAction("Force Mono", this);
    forceMonoAction->setCheckable(true);
    connect(forceMonoAction, SIGNAL(triggered()), SLOT(forceMonoActionTriggered()));
    stationsListAction = new QAction("Stations List", this);
    connect (stationsListAction, SIGNAL(triggered()), SLOT(stationsListActionTriggered()));
    aboutAction = new QAction("About", this); connect(aboutAction, SIGNAL(triggered()), SLOT(about()));
    aboutQtAction = new QAction("About Qt", this); connect(aboutQtAction, SIGNAL(triggered()), SLOT(aboutQt()));

}

void MainWindow::loadSetsName()
{
    QSettings settings("Maemo", "qradio");
    set1Name = settings.value("set1Name", "Set1").toString();
    set2Name = settings.value("set2Name", "Set2").toString();
    set3Name = settings.value("set3Name", "Set3").toString();
}

void MainWindow::saveSetsName()
{
    QSettings settings("Maemo", "qradio");
    settings.setValue("set1Name", set1Name);
    settings.setValue("set2Name", set2Name);
    settings.setValue("set3Name", set3Name);
}

void MainWindow::createMenu()
{
    QMenu *menu;
    menu = menuBar()->addMenu(tr("MENU TITLE"));
    menu->addActions(setsActionGroup->actions());
    menu->addAction(addStationAction);
    menu->addAction(deleteStationAction);
    menu->addAction(manualAction);
    menu->addAction(renameSetsAction);
    //menu->addAction(restartRadioAction);
    menu->addAction(forceMonoAction);
    menu->addAction(stationsListAction);
    menu->addAction(changeFontAction);
    menu->addAction(aboutAction);
    menu->addAction(aboutQtAction);
}

void MainWindow::addStationTriggered()
{
    double freq = w->currentFreq;

    switch (currentSet)
    {
    case (1) :  w->set1List<<(QString::number(freq, 'f', 1)); w->stationsList = w->set1List; break;
    case (2) :  w->set2List<<(QString::number(freq, 'f', 1)); w->stationsList = w->set2List; break;
    case (3) :  w->set3List<<(QString::number(freq, 'f', 1)); w->stationsList = w->set3List; break;
    }

    w->populateBox();
    w->setLastIndex();
}

void MainWindow::loadCurrentSet()
{
    QSettings settings("Maemo", "qradio");
    currentSet = settings.value("currentSet", 1).toInt();
    w->currentSet = currentSet;

    switch (currentSet)
    {
        case (1) : set1Action->setChecked(true); break;
        case (2) : set2Action->setChecked(true); break;
        case (3) : set3Action->setChecked(true); break;
    }
}

void MainWindow::saveCurrentSet()
{
    QSettings settings("Maemo", "qradio");
    settings.setValue("currentSet", currentSet);
}

void MainWindow::set1ActionTriggered()
{
    currentSet = 1;
    saveCurrentSet();
    w->currentSet = currentSet;
    w->populateBox();

}

void MainWindow::set2ActionTriggered()
{
     currentSet = 2;
     saveCurrentSet();
     w->currentSet = currentSet;
     w->populateBox();

}

void MainWindow::set3ActionTriggered()
{
     currentSet = 3;
     saveCurrentSet();
     w->currentSet = currentSet;
     w->populateBox();
}

void MainWindow::manualActionTriggered()
{
    bool ok;
    double manualFreq = QInputDialog::getDouble(this, tr("Manual Freq"), tr("Frequence"), 87.50, 76.0, 108.0, 1, &ok, 0);
    if (ok) w->setFreq(manualFreq*1000000);
}

void MainWindow::renameSetsActionTriggered()
{
    bool ok1;
    bool ok2;
    bool ok3;
    QString set1NameTemp = QInputDialog::getText(this, "Sets Rename", "Insert Set1 Name:", QLineEdit::Normal, set1Name, &ok1 , 0);
    QString set2NameTemp = QInputDialog::getText(this, "Sets Rename", "Insert Set2 Name:", QLineEdit::Normal, set2Name, &ok2 , 0);
    QString set3NameTemp = QInputDialog::getText(this, "Sets Rename", "Insert Set3 Name:", QLineEdit::Normal, set3Name, &ok3 , 0);
    if (ok1) set1Name = set1NameTemp;
    if (ok2) set2Name = set2NameTemp;
    if (ok3) set3Name = set3NameTemp;
    saveSetsName();
    set1Action->setText(set1Name);
    set2Action->setText(set2Name);
    set3Action->setText(set3Name);
}

void MainWindow::deleteStationActionTriggered()
{
    int currentIndex = w->currentIndex;
    switch (currentSet)
    {
    case (1): w->set1List.removeAt(currentIndex); break;
    case (2): w->set2List.removeAt(currentIndex); break;
    case (3): w->set3List.removeAt(currentIndex); break;
    }
    w->populateBox();
}

void MainWindow::about()
{
    QMessageBox::about(this, tr("About QRadio"),
                tr("<h2>QRadio 0.1.4</h2>"
                   "<p>"
                   "<p>Written by Giovanni Grammatico (ggiovanni88@yahoo.it)"));

}

void MainWindow::aboutQt()
{
    QApplication::aboutQt();
}

void MainWindow::changeFontActionTriggered()
{
    b->currentFont = w->getFontType();
    b->currentFontSize = w->getFontSize();
    b->setCurrent();
    b->show();
}

void MainWindow::changeFont(QFont font, int n)
{
    w->changeFont(font, n);
    }

void MainWindow::forceMonoActionTriggered()
{
    if (forceMonoAction->isChecked()) w->forceMono();
    else w->forceStereo();

}

void MainWindow::stationsListActionTriggered()
{
    stationsListCreate();
    wid->setWindowTitle("QRadio");
    wid->show();
}

void MainWindow::stationsListCreate()
{
    widget = new QWidget;
    QScrollArea *scrollArea=new QScrollArea;
    QVBoxLayout *layout=new QVBoxLayout;

    QStringList tempList=w->getStationsList();

    for (int i=0; i<tempList.size(); i++)
    {
        QString tempString=tempList.at(i);
        EmittingButton *button=new EmittingButton(widget, tempString.toDouble());
        layout->addWidget(button);

        connect(button, SIGNAL(buttonClicked(int)), w, SLOT(setFreq(int)));
    }

    layout->addStretch();
    widget->setLayout(layout);
    widget->setMinimumWidth(455);

    scrollArea->setWidget(widget);
    scrollArea->setMinimumWidth(455);

    QLayout *layout1=new QVBoxLayout;
    layout1->addWidget(scrollArea);
    //QPushButton *button = new QPushButton("Close");

   // layout1->addWidget(button);

    wid = new QWidget;

    wid->setLayout(layout1);
    //connect(button, SIGNAL(clicked()), wid, SLOT(close()));

    QFont font(w->getFontType());
    QFont tempfont(font.toString(), 30);
    wid->setFont(tempfont);
    wid->setAttribute(Qt::WA_Maemo5PortraitOrientation);

}
