#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "radio.h"
#include "fontdialog.h"

class QAction;
class QActionGroup;
class QString;
class QStringList;
class Radio;

class MainWindow : public QMainWindow
{
    Q_OBJECT

private:
    void createActions();
    void createMenu();
    void loadSetsName();
    void saveSetsName();
    void loadCurrentSet();
    void saveCurrentSet();

    FontDialog *b;

    QAction *set1Action;
    QAction *set2Action;
    QAction *set3Action;
    QAction *addStationAction;
    QAction *deleteStationAction;
    QAction *manualAction;
    QAction *renameSetsAction;
    QAction *restartRadioAction;
    QAction *changeFontAction;
    QAction *aboutAction;
    QAction *aboutQtAction;

    QActionGroup *setsActionGroup;

    int currentSet;

    QString set1Name;
    QString set2Name;
    QString set3Name;





public slots:
    void addStationTriggered();
    void set1ActionTriggered();
    void set2ActionTriggered();
    void set3ActionTriggered();
    void manualActionTriggered();
    void renameSetsActionTriggered();
    void deleteStationActionTriggered();
    void changeFontActionTriggered();
    void about();
    void aboutQt();
    void changeFont(QFont, int);

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();
    Radio *w;
};

#endif // MAINWINDOW_H
