#ifndef CONTACTSLIST_H
#define CONTACTSLIST_H

#include <QMainWindow>
#include <QStandardItemModel>
#include <QItemSelectionModel>
#include <QMap>
#include <QProgressDialog>
#include "contactsmodel.h"


namespace Ui {
    class ContactsList;
}

class ContactPreview;

class ContactsList : public QMainWindow
{
    Q_OBJECT

public:
    explicit ContactsList(QWidget *parent = 0);
    ~ContactsList();
    QMap<int, ContactData> getSelectedContacts();

public:
    QList<ContactData>* iContacts;

private:
    Ui::ContactsList *ui;
    ContactPreview *iContactPreview;
    ContactsModel *iContactsModel;
    QStandardItemModel *iContactsDataModel;
    QItemSelectionModel *iContactsSelectionModel;
    QProgressDialog *iProgressDialog;
    QAction *aboutAction;

private:
    void setUpdateSelectButtonsState();

private slots:
    void updateList();
    void showPreview();
    void setCheckedItem( QStandardItem *item );
    void enablePreview(QModelIndex current, QModelIndex previous);
    void updateSelectedContacts();
    void setContactsListSelection();
    void showAbout();
};

#endif // CONTACTSLIST_H
