#ifndef CONTACTPREVIEW_H
#define CONTACTPREVIEW_H

#include <QMainWindow>
#include "contactsmodel.h"
#include <QContactManager>
#include <QProgressDialog>

namespace Ui {
    class ContactPreview;
}

class ContactPreview : public QMainWindow
{
    Q_OBJECT

public:
    explicit ContactPreview(QWidget *parent, QList<ContactData> *contacts, QModelIndex *contactItem);
    ~ContactPreview();

signals:
    void showContactsList();


private:
    Ui::ContactPreview *ui;
    QList<ContactData> *iContacts;
    QModelIndex *iContactItem;
    QContactLocalId iContactId;
    QString iContactName;
    QContactManager *iContactManager;
    QProgressDialog *iProgressDialog;
    QAction *aboutAction;

private slots:
    void updateContact();
    void showAbout();
};

#endif // CONTACTPREVIEW_H
