﻿#!/usr/bin/python
# -*- coding: utf-8 -*-

import re 
from QonsoExtractor import QonsoExtractor
from PyQt4 import QtWebKit, QtCore
from PyQt4.QtNetwork import QNetworkRequest

class QonsoExtractorBouygues(QonsoExtractor):
   def __init__(self):
      QonsoExtractor.__init__(self)
      
      self.urlconso = "http://www.espaceclient.bouyguestelecom.fr/ECF/jsf/client/conso-factures/details-conso/viewDetailsConso.jsf"
      self.urlbeforeAuth = "https://www.espaceclient.bouyguestelecom.fr/ECF/jsf/submitLogin.jsf"
      self.urlAuth = "https://www.espaceclient.bouyguestelecom.fr/ECF/jsf/j_security_check;jsessionId="
      self.hostname = "www.espaceclient.bouyguestelecom.fr"

   def Authenticate(self, idCorrelation):
      self.SetStatus('INFO', 'Authentification...')

      request = self.PrepareRequest()
      request.setUrl( QtCore.QUrl(self.urlAuth+idCorrelation) ) 
      
      cookies = self.manager.cookieJar().cookiesForUrl(QtCore.QUrl("http://"+self.hostname))
      for cookie in cookies:
         if cookie.name()=="JSESSIONID":
            request.setRawHeader("Cookie", "testcookie; "+cookie.name()+"="+cookie.value())

      params = QtCore.QUrl()
      params.addQueryItem("j_username", self.login)
      params.addQueryItem("j_password", self.password)
      params.addQueryItem("application_name", "ESPACE_CLIENT_WEB_FORFAIT")
      params.addQueryItem("idCorrelation", idCorrelation)

      self.PostRequest(params, request)
      
   def DoReadResponse(self, reply):
      request = QNetworkRequest()
      page = QtWebKit.QWebPage()
      frame = page.currentFrame()

      # Phase d'initialisation, on va extraire 'idCorrelation', et on lance l'authentification avec
      if self.authentication=='Init':
         html = reply.readAll()
         frame.setHtml(str(html))
         idCorrelation = frame.findFirstElement('input[name=idCorrelation]').attribute('value')
         self.authentication = 'InProgress'
         self.Authenticate(idCorrelation)
      
      # Authentification en cours, on récupère la page de redirection, et on fait une redirection
      elif self.authentication == 'InProgress':
         possibleRedirectUrl = reply.attribute(QNetworkRequest.RedirectionTargetAttribute)
         redirectUrl = possibleRedirectUrl.toUrl()
         request.setUrl( redirectUrl ) 
         self.manager.get(request)
         self.authentication = 'Redirecting'

      # Gestion des redirections, il peut y en avoir plusieurs à la suite
      elif self.authentication == 'Redirecting':
         possibleRedirectUrl = reply.attribute(QNetworkRequest.RedirectionTargetAttribute)
         redirectUrl = str(possibleRedirectUrl.toUrl().toString())
         self.Debug(redirectUrl+str(redirectUrl.find("submitLoginError")))
         
         if redirectUrl and redirectUrl.find("submitLoginError")>0:
            self.SetStatus('ERROR', "Erreur avec vos identifiants")
            redirectUrl = redirectUrl[ redirectUrl.rfind("http"): ]
            request.setUrl( QtCore.QUrl(redirectUrl) ) 
            
         else:
            self.Debug("No more redirection")
            # pas de redirection, on vérifie s'il n'y a pas d'erreur dans la page
            html = reply.readAll()
            frame.setHtml(str(html))
            errors = frame.findAllElements('div[class=erreur]')
            if errors:
               self.Debug("found erreur")
               for error in errors:
                  if error.attribute('id'):  # pas cette erreur (div avec id=errorCookie)
                     continue
                  self.SetStatus('ERROR', error.toInnerXml())
                  return
            else:
               self.Debug( "Pas d'erreur : "+self.status)
               # pas d'erreur, c'est Lesieur, on peut charger la page des consommations
               if self.status == 'ERROR':
                  return
               self.authentication = 'Done'
               self.Debug( "set request="+self.urlconso)
               request.setUrl( QtCore.QUrl(self.urlconso) ) 
               self.SetStatus('INFO', 'R&eacute;cup&eacute;ration des donn&eacute;es...')
            
         self.manager.get(request)
         
   def ExtractDatas(self, datas):
      self.Debug("ExtractDatas")
      self.SetStatus('INFO', 'Extraction des donn&eacute;es...')

      strElem = str(datas)
      
      # Date de la dernière communication
      date = ""
      res = re.search('DetailConsoDateConso">(\d{1,2}/\d{1,2}/\d{2,4})<', strElem)
      if res:
         date = res.group(1)

      # Heure de la dernière communication
      time = ""
      res = re.search('DetailConsoHeureConso">(\d{1,2}h\d{1,2})<', strElem)
      if res:
         time = res.group(1)

      if date and time:
         self.model.lastTime = "Ma consommation au "+date + " &agrave; " + time

      # Date de la prochaine facture
      res = re.search('dateEmissionFacture">(\d{1,2}/\d{1,2}/\d{2,4})<', strElem)
      if res:
         date = res.group(1)
         self.model.facture = "Prochaine facture : "+date+" au soir"

      # Conso Voix
      self.Debug("____________________________________________\nConso voix")
      self.Debug("-----------------------------------------------\n")
      res = re.search("(?:Vous n'avez pas encore profité de)? votre [Ff]orfait (.+?) de %smin" %(self.hmReS), strElem)
      if res:
         self.Debug(res.groups())
         self.model.SetForfait( res.group(1) )
         self.model.SetConsoVoixMax( res.group(2) )
         self.model.SetConsoVoix( "0" )
      
      res = re.search("votre [Ff]orfait (.+) de %smin.+vous avez consomm.+?%s" %(self.hmReS, self.hmReS), strElem)
      if res:
         self.Debug(res.groups())
         self.model.SetForfait( res.group(1) )
         self.model.SetConsoVoixMax( res.group(2) )
         self.model.SetConsoVoix( res.group(3) )
         
      if self.model.forfait.find("Neo")>-1:
         self.model.dataMax = 500
      if self.model.forfait.find("Evasio")>-1:
         self.model.dataMax = 500

      # Conso Voix Supplémentaire
      if self.model.forfait.find("Evasio")>-1:
         self.Debug("____________________________________________\nConso voix Supplémentaire")
         self.Debug("-----------------------------------------------\n")
         res = re.search("Sur votre enveloppe.+vous avez consomm.+%s"%self.hmReS, strElem, re.IGNORECASE)
         if res:
            self.Debug(res.groups())
            self.model.SetConsoVoixSupp( res.group(1) )
            self.model.SetConsoVoixSuppMax( self.model.GetConsoVoixMax('str') )

      # SMS
      self.Debug("____________________________________________\nConso SMS")
      self.Debug("-----------------------------------------------\n")
      res = re.search("pas encore profité de votre [Ff]orfait de (\d+) SMS", strElem)
      if res:
         self.Debug(res.groups())
         self.model.SetConsoSMS( '0' )
         self.model.SetConsoSMSMax( res.group(1) )
      else:
         res = re.search("Sur votre [Ff]orfait de (\d+) SMS.+vous avez consomm.+?(\d+) SMS", strElem)
         if res:
            self.Debug(res.groups())
            self.model.SetConsoSMS( res.group(2) )
            self.model.SetConsoSMSMax( res.group(1) )

      # Bonus SMS
      self.Debug("____________________________________________\nBonus SMS")
      self.Debug("-----------------------------------------------\n")
      res = re.search("avez consommé (.+?) de votre bonus de (\d+) SMS", strElem)
      if res:
         self.Debug(res.groups())
         if res.group(1)=='la totalité':
            self.model.SetConsoSMSSupp( res.group(2) )
         else:
            self.model.SetConsoSMSSupp( res.group(1) )
         self.model.SetConsoSMSSuppMax( res.group(2) )
      else:
         res = re.search("pas encore.+?votre bonus de (\d+) SMS", strElem)
         if res:
            self.Debug(res.groups())
            self.model.SetConsoSMSSupp( '0' )
            self.model.SetConsoSMSSuppMax( res.group(1) )
         else:
            res = re.search("votre bonus de (\d+) SMS.+?vous avez consommé.+?(\d+) SMS", strElem)
            if res:
               self.Debug(res.groups())
               self.model.SetConsoSMSSupp( res.group(2) )
               self.model.SetConsoSMSSuppMax( res.group(1) )
         
      # Report de minutes
      self.Debug("____________________________________________\nReport de minutes")
      self.Debug("-----------------------------------------------\n")
      res = re.search("report de minutes.*Pas de report", strElem, re.IGNORECASE)
      if not res:
         res = re.search("report de minutes.*?<span>.*?%s.*?</span>"%self.hmReS, strElem, re.IGNORECASE)
         if res:
            self.model.SetReport( res.group(1) )
            self.Debug("report = "+res.group(1))
         else:
            res = re.search("report de minutes de\s*%s" % self.hmReS, strElem, re.IGNORECASE)
            if res:
               self.model.SetReport( res.group(1) )
               self.Debug("report = "+res.group(1))

      # Hors forfait
      self.Debug("____________________________________________\nHors forfait")
      self.Debug("-----------------------------------------------\n")
      reHForfait = re.compile(u"montant hors forfait.*?(\d+[\.,]?\d*)\s", re.IGNORECASE|re.DOTALL)
      res = reHForfait.search(strElem)
      if res:
         self.model.SetConsoHorsForfait( res.group(1) )
         self.Debug("hforfait = "+res.group(1))
      
      self.datasExtracted = True
      if self.view:
         self.view.update()
