# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
from string import find, replace


class MyItemDelegate(QtGui.QAbstractItemDelegate):
	def __init__(self, parent, multiselection):
		QtGui.QAbstractItemDelegate.__init__(self,parent)
		self.multi = multiselection
		self.color1 = "#000000"
		self.color2 = "#666666"

		self.defineColor()

	def defineColor(self):
		#data = QtCore.QFile( "./gtkrc" )
		data = QtCore.QFile( "/etc/hildon/theme/gtk-2.0/gtkrc" )
		if ( data.open(QtCore.QFile.ReadOnly | QtCore.QFile.Truncate) ):
			start=0
			out = QtCore.QTextStream(data) #QTextStream
			while ( not out.atEnd() or (start < 2) ):
				line = out.readLine() #QString
				if ( find("%s"%line, "color[\"DefaultTextColor\"]") != -1 ):
					line = replace(line, "color[\"DefaultTextColor\"]", "")
					line = replace(line, "=", "")
					line = replace(line, "\"", "")
					line = replace(line, "\t", "")
					line = replace(line, " ", "")
					self.color1 = line
					start += 1 #++start
				if ( find("%s"%line,"color[\"SecondaryTextColor\"]") != -1 ):
					line = replace(line, "color[\"SecondaryTextColor\"]", "")
					line = replace(line, "=", "") 
					line = replace(line, "\"", "")
					line = replace(line, "\t", "")
					line = replace(line, " ", "")
					self.color2 = line
					start += 1 #++start
				
		data.close()


	def paint(self, painter, option, index): #(self, QObject, QStyleOptionViewItem, QModelIndex)
		fm = option.fontMetrics # fm - QFontMetrics

		name = index.data(QtCore.Qt.StatusTipRole).toString() #QString
		desc = index.data(QtCore.Qt.UserRole+1).toString()

		painter.save()
		r = option.rect #QRect

		if (option.state & QtGui.QStyle.State_Selected):
			is1 = QtGui.QPixmap("/etc/hildon/theme/images/TouchListBackgroundPressed.png"); #QPixmap
			painter.drawTiledPixmap(r,is1)
		else:
			is1 = QtGui.QPixmap("/etc/hildon/theme/images/TouchListBackgroundNormal.png" )
			painter.drawTiledPixmap(r,is1)

		space = 10
		if ( self.multi == 1 ):
			choff = QtGui.QPixmap("/etc/hildon/theme/images/CheckButtonUnchecked.png" ) #QPixmap
			chon = QtGui.QPixmap("/etc/hildon/theme/images/CheckButtonChecked.png" )
			xi = index.data(QtCore.Qt.UserRole+3)
			if ( xi == 1 ):
				painter.drawPixmap( r.left()+6, r.top()+16, 38, 38, chon )
			else:
				painter.drawPixmap( r.left()+6, r.top()+16, 38, 38, choff )
			space = 58

		icon_path = index.data(QtCore.Qt.UserRole+2)
		icon_path = "%s"%icon_path.toString()
		icon = QtGui.QPixmap( icon_path )#.toString())
		painter.drawPixmap( r.left()+space, r.top()+11, 48, 48, icon )

		if ( index.data(QtCore.Qt.UserRole+4) != "" ):
			painter.drawImage( r.left()+space, r.top()+11, QtGui.QImage(index.data(QtCore.Qt.UserRole+4)) )

		base = QtGui.QColor(self.color1)
		painter.setPen(base)

		r = option.rect
		r.setRight( r.right()-4 )
		f = painter.font() #QFont
		f.setBold( False )
		painter.setFont(f)


		#name = fm.elidedText(name, r.width()-56-space, QtCore.Qt.ElideRight) #!!!!
		name = fm.elidedText(name, QtCore.Qt.ElideRight, r.width()-56-space)
		#//desc = fm.elidedText(desc, Qt::ElideRight, r.width()-64-space)

		if ( desc == "" ):
			#painter.drawText(r.left()+54+space, r.top()+1, r.width()-12, r.height(), QtCore.Qt.AlignVCenter|QtCore.Qt.AlignLeft, name, r)
			painter.drawText(r.left()+54+space, r.top()+1, r.width()-12, r.height(), QtCore.Qt.AlignVCenter|QtCore.Qt.AlignLeft, name )
		else:
			#painter.drawText(r.left()+54+space, r.top()+4, r.width()-12, r.height()-8, (QtCore.Qt.AlignTop|QtCore.Qt.AlignLeft), name, r)
			painter.drawText(r.left()+54+space, int("%s"%r.top(),10)+4, int("%s"%r.width(),10)-12, int("%s"%r.height(),10)-8, (QtCore.Qt.AlignTop|QtCore.Qt.AlignLeft), name )
		f.setBold( False )
		painter.setFont( f )


		base = QtGui.QColor( self.color2 )
		painter.setPen( base )
		f.setPointSize( f.pointSize()-4 )
		painter.setFont( f )
		r = option.rect

		if ( desc != "" ):
			painter.drawText(r.left()+54+space, r.top(), r.width()-10, r.height()-8, QtCore.Qt.AlignBottom|QtCore.Qt.AlignLeft, desc)
			#painter.drawText(r.left()+54+space, r.top(), r.width()-10, r.height()-8, QtCore.Qt.AlignBottom|QtCore.Qt.AlignLeft, desc, r)

		if ( index.data(QtCore.Qt.UserRole+5) != None ):
			px = QtGui.QPixmap( index.data(QtCore.Qt.UserRole+5).toString() )
			painter.drawImage( r.right()-50, r.top()+14, QtGui.QImage( px.scaled(42,42) ) )
		
		painter.restore()


	def sizeHint(self, option, index): #(self, QStyleOptionViewItem, QModelIndex)
		s = QtCore.QSize(5, 70)
		return s
