#!/usr/bin/env python

from PySide import QtGui, QtCore

LEFT2RIGHT = 0
RIGHT2LEFT = 1
TOP2BOTTOM = 2
BOTTOM2TOP = 3
AUTOMATIC = 4

class SlidingStackedWidget( QtGui.QStackedWidget ):
	myAnimationFinished = QtCore.Signal()

	def __init__(self, parent = None):
		QtGui.QStackedWidget.__init__(self,parent)
		
		if parent != None:
			self.m_mainwindow = parent
		else:
                        self.m_mainwindow = self

		self.m_vertical = False
		self.m_speed = 500
		self.m_animationtype = QtCore.QEasingCurve.OutBack  #check out the QEasingCurve documentation for different styles
                #self.m_animationtype = QtCore.QEasingCurve.InOutQuint
                #self.m_animationtype = QtCore.QEasingCurve.InElastic
                #self.m_animationtype = QtCore.QEasingCurve.OutExpo
		self.m_now = 0
		self.m_next = 0
		self.m_wrap = False
		self.m_pnow = QtCore.QPoint(0,0)
		self.m_active = False;


	@QtCore.Slot(bool)
	def setVerticalMode(self, vertical):
		self.m_vertical = vertical

        #@QtCore.pyqtSlot(int)
	def setSpeed(self, speed):
		self.m_speed = speed #int msec

        #@QtCore.pyqtSlot(int)
	def setAnimation(self, animationtype):
		self.m_animationtype = animationtype #enum QEasingCurve::Type

        #@QtCore.pyqtSlot(bool)
	def setWrap(self, wrap):
		self.m_wrap = wrap  #True or False

        #@QtCore.pyqtSlot()
	def slideInNext(self):
		now = self.currentIndex() # currentIndex() is a function inherited from QStackedWidget
		if self.m_wrap or (now < (self.count() - 1)):
			#count is inherit from QStackedWidget
			self.slideInIdx( (now + 1) )

        #@QtCore.pyqtSlot()
	def slideInPrev(self):
		now = self.currentIndex()
		if self.m_wrap or (now > 0):
			self.slideInIdx( (now - 1) )

        #@QtCore.pyqtSlot(int)
	def slideInIdx(self, idx, direction = AUTOMATIC): #int idx, enum t_direction direction=AUTOMATIC
		if idx > (self.count() - 1):
			if self.m_vertical == True:
				direction = TOP2BOTTOM
			else:
				direction = RIGHT2LEFT
			idx = idx % self.count()
		elif idx < 0:
			if self.m_vertical == True:
				direction = BOTTOM2TOP
			else:
				direction = LEFT2RIGHT
			idx = ( idx + self.count() ) % self.count()
		
		self.slideInWgt(self.widget( idx ), direction) #widget() is a function inherited from QStackedWidget


	def slideInWgt(self, newwidget, direction):  #QWidget * newwidget, enum t_direction  direction
		if self.m_active:
			return; 
		#at the moment, do not allow re-entrance before an animation is completed.
                #other possibility may be to finish the previous animation abrupt, or
                #to revert the previous animation with a counter animation, before going ahead
                #or to revert the previous animation abrupt
                #and all those only, if the newwidget is not the same as that of the previous running animation.
		else:
			self.m_active = True;

		#enum t_direction directionhint;
                #directionhint = AUTOMATIC
		now = self.currentIndex()	#currentIndex() is a function inherited from QStackedWidget
		next = self.indexOf(newwidget)

		if now == next:
			self.m_active = False
			return
		elif now < next:
			if self.m_vertical == True:
				directionhint = TOP2BOTTOM
			else:
				directionhint = RIGHT2LEFT
		else:
			if self.m_vertical == True:
				directionhint = BOTTOM2TOP
			else:
				directionhint = LEFT2RIGHT

		if direction == AUTOMATIC:
			direction = directionhint
        
		#NOW....
                #calculate the shifts
		offsetx = self.frameRect().width()   #inherited from mother
		offsety = self.frameRect().height()  #inherited from mother

		#the following is important, to ensure that the new widget
		#has correct geometry information when sliding in first time
		
		self.widget( next ).setGeometry( 0,  0, offsetx, offsety )
		
		if direction == BOTTOM2TOP:
			offsetx = 0
			offsety = -offsety
		elif direction == TOP2BOTTOM:
			offsetx = 0
			#offsety=offsety
		elif direction == RIGHT2LEFT:
			offsetx = -offsetx
			offsety=0
		elif direction == LEFT2RIGHT:
			#offsetx=offsetx
			offsety=0

		#re-position the next widget outside/aside of the display area
		#pnext = QtGui.QPoint();
		#pnow = QtGui.QPoint();
		
		pnext = self.widget(next).pos()
		pnow = self.widget(now).pos()

		self.m_pnow = pnow

		self.widget(next).move( pnext.x() - offsetx, pnext.y() - offsety )
		#make it visible/show
		self.widget(next).show()
		self.widget(next).raise_()

		#animate both, the now and next widget to the side, using animation framework
                #QPropertyAnimation *animnow = new QPropertyAnimation(widget(now), "pos");
		animnow = QtCore.QPropertyAnimation( self.widget(now), "pos" )
		
		animnow.setDuration( self.m_speed )
		animnow.setEasingCurve( self.m_animationtype )
		animnow.setStartValue( QtCore.QPoint(pnow.x(), pnow.y()) )
		animnow.setEndValue( QtCore.QPoint(offsetx + pnow.x(), offsety + pnow.y()) )
		
		animnext = QtCore.QPropertyAnimation(self.widget(next), "pos")
		animnext.setDuration( self.m_speed )
		animnext.setEasingCurve( self.m_animationtype )
		animnext.setStartValue( QtCore.QPoint( (-offsetx + pnext.x()), (offsety + pnext.y()) ) )
		animnext.setEndValue( QtCore.QPoint(pnext.x(), pnext.y()) )

		self.animgroup = QtCore.QParallelAnimationGroup();

		self.animgroup.addAnimation( animnow )
		self.animgroup.addAnimation( animnext )

		#QtCore.QObject.connect( self.animgroup, QtCore.SIGNAL("finished()"), self.animationDoneSlot )
                self.animgroup.finished.connect( self.animationDoneSlot )
		self.m_next = next
		self.m_now = now
		self.m_active = True
		self.animgroup.start()

		#note; the rest is done via a connect from the animation ready;
		#animation->finished() provides a signal when animation is done;
		#so we connect this to some post processing slot,
		#that we implement here below in animationDoneSlot.


        #@QtCore.pyqtSlot()
	def animationDoneSlot(self):
		#when ready, call the QStackedWidget slot setCurrentIndex(int)
		self.setCurrentIndex( self.m_next )   #this function is inherit from QStackedWidget
		#then hide the outshifted widget now, and  (may be done already implicitely by QStackedWidget)
		self.widget( self.m_now ).hide()
		#then set the position of the outshifted widget now back to its original
		self.widget( self.m_now ).move( self.m_pnow )
		#so that the application could also still call the QStackedWidget original functions/slots for changings
		#widget(m_now)->update();
		#setCurrentIndex(m_next);  #this function is inherit from QStackedWidget
		self.m_active = False
		
		self.myAnimationFinished.emit();

	

