import Qt 4.7

Item {
    id: dialog

    property string username
    property string id
    property string thumbnail
    property string subscriberCount
    property string videoCount
    property bool isSubscribed

    signal userVideosClicked(string username)
    signal close

    function getUserProfile(user) {
        username = user;

        var i = 0;
        while ((!isSubscribed) && (i < subscriptionsModel.count)) {
            if (subscriptionsModel.get(i).title == username) {
                id = subscriptionsModel.get(i).subscriptionId.split(":")[5];
                isSubscribed = true;
            }
            i++;
        }

        var doc = new XMLHttpRequest();
        doc.onreadystatechange = function() {
            if (doc.readyState == XMLHttpRequest.DONE) {
                var xml = doc.responseXML.documentElement;
                for (var i = 0; i < xml.childNodes.length; i++) {
                    if (xml.childNodes[i].nodeName == "thumbnail") {
                        thumbnail = xml.childNodes[i].attributes[0].value;
                    }
                    else if (xml.childNodes[i].nodeName == "statistics") {
                        subscriberCount = xml.childNodes[i].attributes[1].value;
                    }
                    else if (xml.childNodes[i].nodeName == "feedLink") {
                        if (xml.childNodes[i].attributes[0].value == "http://gdata.youtube.com/schemas/2007#user.uploads") {
                            videoCount = xml.childNodes[i].attributes[2].value;
                        }
                    }
                }
            }
        }
        doc.open("GET", "http://gdata.youtube.com/feeds/api/users/" + username + "?v=2");
        doc.send();
    }

    width: parent.width
    anchors { right: parent.left; top: parent.top; bottom: parent.bottom }

    Connections {
        target: dialog.parent

        onDialogClose: {
            dialog.state = "";
            dialog.destroy(600);
        }
    }


    Connections {
        target: YouTube

        onSubscribed: isSubscribed = true
        onUnsubscribed: isSubscribed = false
    }

    Rectangle {
        id: background

        color: _BACKGROUND_COLOR
        opacity: 0.5
    }

    Row {
        spacing: 10
        anchors { left: dialog.left; right: subscribeButton.left; top: dialog.top; bottom: dialog.bottom; margins: 10 }

        Rectangle {
            id: frame

            width: Math.floor(dialog.width / 3.2)
            height: Math.floor(frame.width / (4 / 3))
            color: _BACKGROUND_COLOR
            border.width: 2
            border.color: mouseArea.pressed ? _ACTIVE_COLOR_LOW : "white"

            Image {
                id: thumb

                anchors { fill: frame; margins: 2 }
                source: thumbnail
                smooth: true

            }

            MouseArea {
                id: mouseArea

                anchors.fill: frame
                onClicked: {
                    userVideosClicked(username);
                    close();
                }
            }
        }

        Text {
            width: dialog.width / 2
            text: username
            color: _TEXT_COLOR
            elide: Text.ElideRight
            font.pixelSize: _STANDARD_FONT_SIZE

            Grid {
                id: textColumn

                width: dialog.width / 2
                anchors { left: parent.left; top: parent.bottom; topMargin: 5 }
                columns: 2
                spacing: 5

                Text {
                    text: qsTr("Subscribers")
                    color: _TEXT_COLOR
                    elide: Text.ElideRight
                    font.pixelSize: _STANDARD_FONT_SIZE
                }

                Text {
                    text: subscriberCount
                    color: "grey"
                    elide: Text.ElideRight
                    font.pixelSize: _STANDARD_FONT_SIZE
                }

                Text {
                    text: qsTr("Videos")
                    color: _TEXT_COLOR
                    elide: Text.ElideRight
                    font.pixelSize: _STANDARD_FONT_SIZE
                }

                Text {
                    text: videoCount
                    color: "grey"
                    elide: Text.ElideRight
                    font.pixelSize: _STANDARD_FONT_SIZE
                }
            }
        }

    }

    PushButton {
        id: subscribeButton

        anchors { bottom: dialog.bottom; right: dialog.right; margins: 10 }
        showIcon: false
        showText: true
        name: isSubscribed ? "Unsubscribe" : "Subscribe"
        onButtonClicked: {
            if (isSubscribed) {
                YouTube.unsubscribeToChannel(id);
            }
            else {
                YouTube.subscribeToChannel(username);
            }
            close();
        }
    }

    CloseButton {
        onButtonClicked: close()
    }

    MouseArea {

        property real xPos

        z: -1
        anchors.fill: dialog
        onPressed: xPos = mouseX
        onReleased: {
            if (xPos - mouseX > 100) {
                close();
            }
        }
    }

    states: State {
        name: "show"
        AnchorChanges { target: dialog; anchors.right: parent.right }
    }

    transitions: Transition {
        AnchorAnimation { easing.type: Easing.OutQuart; duration: 500 }
    }
}
