import QtQuick 1.0

Item {
    id: banner

    property alias message : messageText.text

    height: 70

    Rectangle {
        id: background

        anchors.fill: banner
        color: activeColorLow
        smooth: true
        opacity: 0.7
    }

    Text {
        id: messageText


        anchors.fill: banner
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
        wrapMode: Text.WordWrap
        font.pixelSize: standardFontSize
        color: "white"
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: banner; height: 105 }
    }
}
