import QtQuick 1.0

Rectangle {
    id: delegate

    signal delegateClicked(string setting)

    width: delegate.ListView.view.width
    height: 100
    color: "black"

    ListHighlight {
        visible: (mouseArea.pressed) || (delegate.ListView.view.currentIndex == index)
    }

    Text {
        id: titleText
        elide: Text.ElideRight
        text: setting
        color: "white"
        font.pixelSize: standardFontSize
        anchors.fill: parent
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    Rectangle {
        height: 1
        anchors { bottom: delegate.bottom; left: delegate.left; leftMargin: 10; right: delegate.right; rightMargin: 10 }
        color: activeColor
        opacity: 0.5
        visible: !(index == delegate.ListView.view.count - 1)
    }

    MouseArea {
        id: mouseArea

        anchors.fill: parent
        onClicked: delegateClicked(titleText.text)
    }
}
