import QtQuick 1.0
import "settings.js" as Settings

Rectangle {
    id: searchBar

    property alias searchText : searchInput.text

    signal search(string query)
    signal video(string videoId)

    function parseSearchQuery() {
        var query = searchInput.text;
        var pattern = /youtu.be|watch\?v=/; // Check if user entered a direct link to a video
        if (pattern.test(query)) {
            var videoId = query.substr(query.length - 11); // Extract videoId from link
            video(videoId);
        }
        else {
            search(query);
            Settings.addSearchTerm(query);

        }
    }

    function getSearches() {
        /* Retreive the searches from the database and
          populate the model */

        var searches = Settings.getSearches();
        for (var i = 0; i < searches.length; i++) {
            searchModel.insert(0, { "searchterm": searches[i] });
        }
    }

    height: searchList.count == 0 ? 40 : searchList.count > 6 ? 320 : 50 + searchList.count * 40
    color:  "white"
    border.width: 2
    border.color: activeColorLow
    radius: 5
    smooth: true

    Component.onCompleted: getSearches()

    Behavior on height { PropertyAnimation { properties: "height"; easing.type: Easing.OutQuart; duration: 500 } }

    TextInput {
        id: searchInput

        anchors { fill: searchBar; margins: 2 }
        font.pixelSize: standardFontSize
        selectByMouse: true
        selectionColor: activeColorLow
        smooth: true
        focus: true
        Keys.onEnterPressed: {
            if (searchInput.text != "") {
                parseSearchQuery();
            }
        }
    }

    ListView {
        id: searchList

        anchors { fill: searchBar; topMargin: 45; leftMargin: 4; rightMargin: 4; bottomMargin: 10 }
        clip: true
        visible: !(searchList.count == 0)

        model: ListModel {
            id: searchModel
        }

        delegate: SearchDelegate {
            id: delegate

            Connections {
                onDelegateClicked: {
                    search(searchterm);
                    Settings.addSearchTerm(searchterm);
                }
            }
        }

        ScrollBar {}
    }
}
