#include "youtube.h"
#include <QtNetwork/QNetworkRequest>
#include <QtNetwork/QNetworkReply>
#include <QString>
#include <QRegExp>
#include <QUrl>
#include <QDebug>
#include <QMap>
#include <QStringList>
#include <QTimer>

YouTube::YouTube(QObject *parent) :
    QObject(parent), playbackQuality(18) {
}

void YouTube::setPlaybackQuality(const int &quality) {
    playbackQuality = quality;
}

void YouTube::getVideoUrl(const QString &playerUrl) {
    QNetworkAccessManager *manager = new QNetworkAccessManager(this);
    QNetworkRequest request;
    request.setUrl(QUrl(playerUrl));
    connect(manager, SIGNAL(finished(QNetworkReply*)), this, SLOT(parseVideoPage(QNetworkReply*)));
    manager->get(request);
}

void YouTube::parseVideoPage(QNetworkReply *reply) {
    QNetworkAccessManager *manager = qobject_cast<QNetworkAccessManager*>(sender());

    QMap<int, QByteArray> formats;
    QByteArray response = reply->readAll();
    response = response.simplified().replace(QByteArray(" "), QByteArray(""));
    int pos = response.indexOf("\",\"fmt_url_map\":\"") + 17;
    int pos2 = response.indexOf('\"', pos);
    response = response.mid(pos, pos2 - pos);
    QList<QByteArray> parts = response.split('|');
    int key = parts.first().toInt();
    for (int i = 1; i < parts.length(); i++) {
        QByteArray part = parts[i];
        QList<QByteArray> keyAndValue = part.split(',');
        QByteArray url = keyAndValue.first().replace(QByteArray("\\/"), QByteArray("/")).replace(QByteArray("\\u0026"), QByteArray("&"));
        formats[key] = url;
        key = keyAndValue.last().toInt();
    }
    QList<int> flist;
    flist << 22 << 35 << 34 << 18 << 5;
    QByteArray videoUrl = "";
    int index = flist.indexOf(playbackQuality);
    while ((videoUrl == "") && index < flist.size()) {
        videoUrl = formats.value(flist.at(index), "");
        index++;
    }
    if (videoUrl == "") {
        emit videoUrlError();
    }
    else {
        emit gotVideoUrl(QString(videoUrl));
    }
    reply->deleteLater();
    manager->deleteLater();
}
