import QtQuick 1.0

Rectangle {
    id: button
    width: 112
    height: 60
    visible: addStationButton.state == "base state"

    property alias freqText: freq.text
    signal buttonClicked()
    signal buttonHold()

    gradient: Gradient {
        GradientStop { position: 0; color: "#33000000" }
        GradientStop { position: 0.3; color: "#33dddddd" }
        GradientStop { position: 0.99; color: "#33000000" }
    }

    Text {
        id: freq
        anchors.centerIn: button
        text: "99.200"
        font.pointSize: 17
        color: "white"

    }

    MouseArea {
             id: mouseArea
             anchors.fill: parent
             onClicked: {
                 buttonClicked()
                 //radio.setFreq(freq.text)

             }
             onPressAndHold: {
                 buttonHold()
                 //freq.text = radio.getFreq()
             }
    }

    states: [
        State {
            name: "pressed"
            when: mouseArea.pressed == true
            PropertyChanges {
                target: button
                opacity: .6
            }
        }
    ]
}
