import QtQuick 1.0

Rectangle {
    id: button
    width: 100
    height: 55
    radius: 8
    color: "#000000ff"
    border.color: "white"
    border.width: 3

    signal buttonClicked()

    Rectangle {
        width: 30
        height: 30
        radius: 30
        color: "white"
        anchors.centerIn: parent
        anchors.margins: 3
    }

    Rectangle {
        width: 30
        height: 30
        radius: 30
        border.color:"white"
        border.width: 1
        color: "#000000ff"
        anchors.centerIn: parent
    }

    MouseArea {
        id: mouseArea
        anchors.fill: parent
        onClicked: {
            buttonClicked()
            console.debug("MultitaskButton clicked")
        }
    }

    states: State {
             name: "pressed"
             when: mouseArea.pressed == true
             PropertyChanges {
                 target: button
                 opacity: .5
             }
    }
}
