import QtQuick 1.0

Rectangle {
    id: infoBanner
    y: 30
    width: 800
    height: 62
    opacity: 0

    function show(message) {
        text.text = message
        bannerAnimation.start()
    }

    gradient: Gradient {
        GradientStop { position: 0; color: "#ffffff" }
        GradientStop { position: 0.1; color: "darkcyan" }
        GradientStop { position: 0.3; color: "darkblue" }
        GradientStop { position: 0.9; color: "darkcyan" }
        GradientStop { position: 1.0; color: "white" }
    }

    Text {
        id: text
        text: "text"
        font.pointSize: 20
        color: "white"
        anchors.centerIn: infoBanner
    }

    SequentialAnimation {
        id: bannerAnimation
        ParallelAnimation {
            PropertyAnimation {
                targets: infoBanner
                property: "opacity"
                to: 0.9
            }
            PropertyAnimation {
                targets: infoBanner
                property: "y"
                to: 70
            }
        }
        PauseAnimation { duration: 3000 }
        ParallelAnimation {
            PropertyAnimation {
                id: animation01
                target: infoBanner
                property: "opacity"
                to: 0
            }
            PropertyAnimation {
                target: infoBanner
                property: "y"
                to: 30
            }
        }



    }
}
