import QtQuick 1.0

Rectangle {
    id: mainBox

    property string inputText: textInput.text
    signal closed
    signal nameFilled

    width: 60
    height: 60
    state: "base state"

    gradient: Gradient {
        GradientStop { position: 0; color: "#33000000" }
        GradientStop { position: 0.3; color: "#33dddddd" }
        GradientStop { position: 0.99; color: "#33000000" }
    }

    Rectangle {
        x: 10
        y: 27
        width: 40
        height: 5
        radius: 5
        scale: 0.7

        color: "white"

    }

    Rectangle {
        x: 10
        y: 27
        width: 40
        height: 5
        rotation: -90
        radius: 5
        scale: 0.7

        color: "white"

    }

    TextInput {
        id: textInput
        anchors { fill: mainBox; leftMargin: 70; topMargin: 13 }
        text: "text input pqtest"
        color: "white"
        font.pixelSize: 27

        onAccepted: {
            if (inputText == "")
                    {
                        mainBox.state = "base state"

                    }
            else
            {
                mainBox.state = "base state"
                textInput.focus = false
                modelManager.addStation(inputText, radio.getFreq())
            }
        }

    }

    MouseArea {
        anchors.fill: parent

        onClicked:  {
            console.debug("AddStationButton clicked, state: " + mainBox.state)
            if ( mainBox.state == "base state" )
            {
                console.debug("state is base state")
                mainBox.state = "Enlarged"
                textInput.text = ""
                textInput.focus = true
            }
            else if ( mainBox.state == "Enlarged" )
            {
                console.debug("state is enlarged state")
                mainBox.state = "base state"
                textInput.focus = false
            }

        }
    }

    Behavior on width {
        NumberAnimation {
        duration: 100
        }
    }


    states: [
        State {
            name: "Enlarged"

            PropertyChanges {
                target: mainBox
                width: 311
            }


        }
    ]

}
