import QtQuick 1.0
import org.hildon.components 1.0
import org.hildon.browser 1.0

PageStackWindow {
    id: appWindow

    property alias tabs: mainPage.tabs
    property alias tabGroup: mainPage.tabGroup
    property alias currentTab: mainPage.currentTab

    windowTitle: qsTr("QML Browser")
    initialPage: MainPage {
        id: mainPage
    }

    Settings {
        id: settings

        fileName: "/home/user/.config/QMLBrowser/browser.conf"
    }

    BookmarksModel {
        id: bookmarks

        fileName: "/home/user/.config/QMLBrowser/bookmarks.xml"
    }

    InfoBanner {
        id: infoBanner

        function showMessage(message) {
            infoLabel.text = message;
            infoBanner.open();
        }

        content: Label {
            id: infoLabel

            anchors.fill: parent
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            color: theme.notificationTextColor
        }
    }

    InfoNote {
        id: infoNote

        function showMessage(message) {
            noteLabel.text = message;
            infoNote.open();
        }

        content: Label {
            id: noteLabel

            anchors.fill: parent
            verticalAlignment: Text.AlignVCenter
            color: theme.notificationTextColor
        }
    }
}
