/*******************************************************************************
**
** vkconfiguration.cpp - implement VkConfiguration, config manager for plug-in.
**                       Inherited by QMailServiceConfiguration.
** This file is part of the QMF-Vkontakte plug-in.
**
** Copyright (C) 2010 PetrSU. Pavel Shiryaev <shiryaev AT cs.karelia.ru>
** Contact: QMF-vkontakte team (qmf-vkontakte AT cs.karelia.ru)
**
** QMF-Vkontakte plug-in is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** QMF-Vkontakte plug-in is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with QMF-Vkontakte plug-in; if not, write to the Free Software
** Foundation, Inc., 51 Franklin St, Fifth Floor,
** Boston, MA  02110-1301  USA
**
*******************************************************************************/

#include "vkconfiguration.h"


VkConfiguration::VkConfiguration(const QMailAccountConfiguration &config)
    : QMailServiceConfiguration(config, "vk")
{
    setType(SourceAndSink);
}

VkConfiguration::VkConfiguration(
        const QMailAccountConfiguration::ServiceConfiguration &svcCfg)
    : QMailServiceConfiguration(svcCfg)
{
}

QString VkConfiguration::vkUserName() const
{
    return value("username");
}

QString VkConfiguration::vkPassword() const
{
    return decodeValue(value("password"));
}

QString VkConfiguration::proxyServer() const
{
    return value("server");
}

QString VkConfiguration::serviceHost() const
{
    return value("servicehost", "http://vkontakte.ru");
}

int VkConfiguration::proxyPort() const
{
    return value("port", "3128").toInt();
}

bool VkConfiguration::canDeleteMail() const
{
    return (value("canDelete", "0").toInt() != 0);
}

int VkConfiguration::checkInterval() const
{
    return value("checkInterval", "-1").toInt();
}

int VkConfiguration::messagesInterval() const
{
    return value("messagesInterval", "10").toInt();
}

VkConfiguration::ProxyStatus VkConfiguration::proxyState() const
{
    // WARNING: enum ProxyStatus can be changed in later versions
    return static_cast<ProxyStatus>(value("proxyState", "0").toInt());
}

bool VkConfiguration::captchaState() const
{
    return value("captchaState", "0").toInt() != 0;
}

QByteArray VkConfiguration::captchaCode() const
{
    return value("captchaCode").toAscii();
}

QByteArray VkConfiguration::captchaText() const
{
    return value("captchaText").toAscii();
}

QByteArray VkConfiguration::captchaImg() const
{
    return value("captchaImg").toAscii();
}

VkConfigurationEditor::VkConfigurationEditor(QMailAccountConfiguration *config)
    : VkConfiguration(*config)
{
}

void VkConfigurationEditor::setMailUserName(const QString &str)
{
    setValue("username", str);
}

void VkConfigurationEditor::setMailPassword(const QString &str)
{
    setValue("password", encodeValue(str));
}

void VkConfigurationEditor::setProxyServer(const QString &str)
{
    setValue("server", str);
}

void VkConfigurationEditor::setProxyPort(int i)
{
    setValue("port", QString::number(i));
}

void VkConfigurationEditor::setDeleteMail(bool b)
{
    setValue("canDelete", QString::number(b ? 1 : 0));
}

void VkConfigurationEditor::setAutoDownload(bool b)
{
    setValue("autoDownload", QString::number(b ? 1 : 0));
}

void VkConfigurationEditor::setProxyState(int state)
{
    setValue("proxyState", QString::number(state));
}

void VkConfigurationEditor::setCaptchaState(bool state)
{
    setValue("captchaState", QString::number(state));
}

void VkConfigurationEditor::setCaptchaCode(const QByteArray &str)
{
    setValue("captchaCode", str);
}

void VkConfigurationEditor::setCaptchaText(const QByteArray &str)
{
    setValue("captchaText", str);
}

void VkConfigurationEditor::setCaptchaImg(const QByteArray &str)
{
    setValue("captchaImg", str);
}

void VkConfigurationEditor::setCheckInterval(int i)
{
    setValue("checkInterval", QString::number(i));
}

void VkConfigurationEditor::setMessagesInterval(int i)
{
    setValue("messagesInterval", QString::number(i));
}
