/*******************************************************************************
**
** vksettingssource.h - implement VkSettingsSource, gui configurator
**                      of settings for source function of Vkontakte service.
**                      Inherited by QMailMessageServiceEditor.
** This file is part of the QMF-Vkontakte plug-in.
**
** Copyright (C) 2010 PetrSU. Pavel Shiryaev <shiryaev AT cs.karelia.ru>
** Contact: QMF-vkontakte team (qmf-vkontakte AT cs.karelia.ru)
**
** QMF-Vkontakte plug-in is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** QMF-Vkontakte plug-in is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with QMF-Vkontakte plug-in; if not, write to the Free Software
** Foundation, Inc., 51 Franklin St, Fifth Floor,
** Boston, MA  02110-1301  USA
**
*******************************************************************************/

#ifndef VKSETTINGSSOURCE_H
#define VKSETTINGSSOURCE_H

#include "ui_vksettingssource.h"
#include <qmailmessageservice.h>

class VkSettingsSource : public QMailMessageServiceEditor, private Ui::VkSettingsSource
{
    Q_OBJECT

public:
    VkSettingsSource();

    void displayConfiguration(const QMailAccount &account,
                              const QMailAccountConfiguration &config);
    bool updateAccount(QMailAccount *account,
                       QMailAccountConfiguration *config);

private slots:
    void intervalCheckChanged(int enabled);
    void proxyStateChanged(bool enabled);
private:
    bool warningEmitted;
    QMailFolderId inboxFolderId;
    QMailFolderId sentFolderId;
    QMailFolderId wallFolderId;
};

#endif

