#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QNetworkAccessManager>
#include <QUrl>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QByteArray>
#include <QNetworkCookieJar>
#include <QNetworkCookie>
#include <QLineEdit>
#include <QNetworkProxy>
#include <QLabel>
#include <QString>
#include <QGraphicsScene>
#include <QPixmap>
#include <QDateTime>
#include <QBuffer>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT
public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:

    void changeEvent(QEvent *e);
private:
    Ui::MainWindow *ui;
    QNetworkAccessManager* nam;
    QNetworkReply* reply;
    QLabel* sm;
    QNetworkProxy *proxy;
    QGraphicsScene *myscene;
    QPixmap *mypix;
    QString *fcsid;
    QString *sid;
    QString *fccode;
    QBuffer *tasks;
    QString *remixmid;




    enum States {
      Send, Resived
    };

private slots:
    void on_senMessageButton_clicked();
    void on_setCaptchButton_clicked();
    void on_getCaptchButton_clicked();
    void on_setProxyButton_clicked();
    void on_getSidButton_clicked();
    void on_getLinkButton_clicked();
    void on_pushButton_clicked();
    void finishedSlot(QNetworkReply* reply);
    void readyReadAuthReply();
    void getSidFromReply();
    void getCaptchFromReply();
    void finishedReadReply();
    void processTasks();

    void replyError(QNetworkReply::NetworkError);
};
#endif // MAINWINDOW_H
