/*******************************************************************************
**
** vkconfiguration.h - implement VkConfiguration, config manager for plug-in.
**                       Inherited by QMailServiceConfiguration.
** This file is part of the QMF-Vkontakte plug-in.
**
** Copyright (C) 2010 PetrSU. Pavel Shiryaev <shiryaev AT cs.karelia.ru>
** Contact: QMF-vkontakte team (qmf-vkontakte AT cs.karelia.ru)
**
** QMF-Vkontakte plug-in is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** QMF-Vkontakte plug-in is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with QMF-Vkontakte plug-in; if not, write to the Free Software
** Foundation, Inc., 51 Franklin St, Fifth Floor,
** Boston, MA  02110-1301  USA
**
*******************************************************************************/

#ifndef VKCONFIGURATION_H
#define VKCONFIGURATION_H

#include <qmailserviceconfiguration.h>

class PLUGIN_EXPORT VkConfiguration : public QMailServiceConfiguration
{
public:
    explicit VkConfiguration(const QMailAccountConfiguration &config);
    explicit VkConfiguration(
            const QMailAccountConfiguration::ServiceConfiguration &svcCfg);

    QString vkUserName() const;
    QString vkPassword() const;
    QString proxyServer() const;
    QString serviceHost() const;
    int proxyPort() const;
    bool canDeleteMail() const;
    int checkInterval() const;
    int messagesInterval() const;
    bool captchaState() const;
    QByteArray captchaCode() const;
    QByteArray captchaText() const;
    QByteArray captchaImg() const;
    enum ProxyStatus
    {
        NoProxy,     // Libvkontakte will work without proxy
        SystemProxy, // Try get system proxy for vk.com
        ManualProxy  // Proxy from settings window
    };
    ProxyStatus proxyState() const;
};

class PLUGIN_EXPORT VkConfigurationEditor : public VkConfiguration
{
public:
    explicit VkConfigurationEditor(QMailAccountConfiguration *config);

    void setMailUserName(const QString &str);
    void setMailPassword(const QString &str);
    void setProxyServer(const QString &str);
    void setProxyPort(int i);
    void setDeleteMail(bool b);
    void setAutoDownload(bool autodl);
    void setCaptchaState(bool state);
    void setCaptchaCode(const QByteArray &str);
    void setCaptchaText(const QByteArray &str);
    void setCaptchaImg(const QByteArray &str);
    void setProxyState(int state);
    void setCheckInterval(int i);
    void setMessagesInterval(int i);
};

#endif
