/*******************************************************************************
**
** vkservice.h - implement VkService and VkServicePlugin, main of plug-in.
**                       Inherited by QMailServiceConfiguration.
** This file is part of the QMF-Vkontakte plug-in.
**
** Copyright (C) 2010 PetrSU. Pavel Shiryaev <shiryaev AT cs.karelia.ru>
** Contact: QMF-vkontakte team (qmf-vkontakte AT cs.karelia.ru)
**
** QMF-Vkontakte plug-in is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** QMF-Vkontakte plug-in is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with QMF-Vkontakte plug-in; if not, write to the Free Software
** Foundation, Inc., 51 Franklin St, Fifth Floor,
** Boston, MA  02110-1301  USA
**
*******************************************************************************/

#ifndef VKSERVICE_H
#define VKSERVICE_H

#include "vkclient.h"
#include <qmailmessageservice.h>

class VkService : public QMailMessageService
{
    Q_OBJECT

public:
    using QMailMessageService::updateStatus;

    VkService(const QMailAccountId &accountId);
    ~VkService();

    virtual QString service() const;
    virtual QMailAccountId accountId() const;

    virtual bool hasSource() const;
    virtual QMailMessageSource &source() const;

    virtual bool hasSink() const;
    virtual QMailMessageSink &sink() const;

    virtual bool available() const;

public slots:
    virtual bool cancelOperation(QMailServiceAction::Status::ErrorCode code, const QString &text);

protected slots:
    void errorOccurred(int code, const QString &text);
    void errorOccurred(QMailServiceAction::Status::ErrorCode code,
                       const QString &text);

    void updateStatus(const QString& text);

private:
    class Source;
    friend class Source;

    class Sink;
    friend class Sink;

    VkClient _client;
    Source *_source;
    Sink *_sink;
};


class VkServicePlugin : public QMailMessageServicePlugin
{
    Q_OBJECT

public:
    VkServicePlugin();

    virtual QString key() const;
    virtual bool supports(QMailMessageServiceFactory::ServiceType type) const;
    virtual bool supports(QMailMessage::MessageType type) const;

    virtual QMailMessageService *createService(const QMailAccountId &id);
    virtual QMailMessageServiceConfigurator *createServiceConfigurator();
};


#endif
