/*******************************************************************************
**
** vktransport.h - transport module for QMF-Vkontakte plug-in
** Based on livkontakte API:  http://oss.fruct.org/wiki/Libvkontakte/xml-data
** This file is part of QMF-Vkontakte plug-in.
**
** Copyright (C) 2010 Pavel Shiryaev <shiryaev AT cs.karelia.ru>
** Copyright (C) 2010 - Nikolai Agafonov
**
** QMF-Vkontakte plug-in is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** QMF-Vkontakte plug-in is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with QMF-Vkontakte plug-in; if not, write to the Free Software
** Foundation, Inc., 51 Franklin St, Fifth Floor,
** Boston, MA  02110-1301  USA
**
*******************************************************************************/

#ifndef VKTRANSPORT_H
#define VKTRANSPORT_H
#define FACEBOOK_ONLY

#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>

#include <glib.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <mysocials_driver.h>

#include <QObject>
#include <QString>
#include <QImage>
#include <QTextCodec>
#include <QLibrary>
#include <qmailmessage.h>

// if VK_LOGING define, then will writes libvkontakte api transfer data
#define VK_LOGING

#ifdef VK_LOGING
// Name of file for writing log. Will located in temp directory
#define VK_LOGING_FILE "vkLog.log"
#include <QDir>
#endif

// id of client in requests to library
#define CLIENT_NAME "fb_client"

#define VK_AT '@'
#define VK_FAKE_ADDRESS "@fb.com"
#define VK_FAKE_ADDRESS_PATTERN "\\d+@fb\\.com"

#define VK_DEFAULT_SUBJECT "..."
#define VK_SUBJECT_LENGTH 20
#define VK_MESSAGES_AT_ONCE 10
#define VK_MIN_MESSAGES_AT_ONCE 2

#define VK_UID_SEPARATOR '_'
class VkResponse;

class VkTransport : public QObject
{
    Q_OBJECT

public:
    VkTransport();
    VkTransport(QByteArray);
    ~VkTransport();

    void vkGetProfile();
    void vkGetProfile(QByteArray captchaCode, QByteArray captchaText);
    QString vkUserName() const;
    void vkInit(QString, uint);
    void vkSetId(QMailAccountId id);
    void vkIgnoreSender(bool);

    void vkTestConnection();
    void vkSetSettings(QString);
    void vkSendMessage(QByteArray strRecipientId, QByteArray strText);
    void vkReadMessage(QString messageId);
    void vkDeleteMessage(QString messageId);
    void vkGetNewInbox();
    void vkCreateRemoved();
    void vkCleareRemoved();
    QString vkSubjectFromBody(QString body);
    void vkClose();
    uint totalInboxCount;
    uint totalOutboxCount;

    enum Action
    {
        updateProfileAction, getProfileAction,
        getProfilesAction, updateListFriendsAction,
        getListFriendsAction, getSettingsAction,
        setSettingsAction, getNewInboxMessagesAction,
        getOutboxMessagesAction, getInboxMessagesAction,
        sendMessageAction, errorMessageAction,
        infoMessageAction, captchaMessageAction,
        getBinaryDataAction, updateInboxMessagesAction,
        updateOutboxMessagesAction, unknownAction
    };

public slots:
    void vkGetSettings();
    void vkGetSend();
    void vkGetSend(int reqFrom, int reqTo);
    void vkGetInbox();
    void vkGetInbox(int reqFrom, int reqTo);
    void vkSendRequest(QByteArray xmlRequest);
    void vkGetInboxCount();
    void vkGetInboxCount(QByteArray timeOffset);
    void vkGetOutboxCount();
    void vkGetOutboxCount(QByteArray timeOffset);

signals:
    void readyRead();
    //void vkGetRequest(QByteArray);
    void responseReceived(VkResponse*);
    void errorOccurred(int,QString);
    void updateStatus(QString);
    void pushNewMessage(QMailMessage *message);
    void progressChanged(uint, uint);
    void settingsReceived(QByteArray);
    void totalOutboxQuantityReceived(QByteArray);
    void totalInboxQuantityReceived(QByteArray);

private:


#ifdef VK_LOGING
    FILE *vkLog;    // log-file
#endif

    // A set of functions that are used to parse XML response.
    void parseOneNodeSet(xmlXPathObjectPtr &object, xmlChar *xpathRequest,
                         xmlXPathContextPtr &content);
    char* parseString(xmlChar *xpathRequest, xmlXPathContextPtr &content,
                      bool important);
    char* parseString(QByteArray charRequest, xmlXPathContextPtr &content,
                      bool important);
    xmlNodePtr xpath_get_node(char* path, xmlDocPtr doc);
    xmlXPathObject* xpath(gchar* req, xmlDocPtr doc);

    // Pointer to social network driver library
    QLibrary *msa;

    // profile settings in library
    struct msa_module *driverModule;

    // Encoder from one-bit to two-bit encoding (utf-8)
    QTextCodec *decoder;

    // Id of account for getting data from mailStore
    QMailAccountId id;
    QByteArray accountName;

    // Name that will be set as Sender fo sent and Receiver for inbox,
    // We haven't this information from message data, only from account profile.
    QString userName;
    QString userId;

    // Messages uids that was removed localy, but cannot removed now from server
    QSet<QString> removed;

    // If true then allow to erase special removal records.
    bool cannotPurgeMessageRemovalRecords;

    // If true then remove sender from recipients
    bool canIgnoreSender;

    // If was stopped processing
    bool needShutdown;

    // Counter for requests to library
    long activeRequests;
};

class VkResponse {
public:
    VkResponse();
    ~VkResponse();
    VkTransport::Action action; // Status of Response
    QByteArray captchaImg;      // Image of captcha, for getting user
    QByteArray midFrom;         // First Message id from Response
    QByteArray midTo;           // Last Message id from Response
    QString* text;              // Info or error text from libkontakte
    QByteArray code;            // Info or error code from libkontakte
};


#endif // VKTRANSPORT_H
