#include "widget.h"

Widget::Widget(QWidget *parent)
    : QWidget(parent)
{
    megaphoneActive = false;
    transmitterActive = false; //check

    QDBusConnection::systemBus().connect("com.nokia.FMTx",
                                         "/com/nokia/fmtx/default",
                                         "com.nokia.policy",
                                         "info", this,
                                         SLOT(onTransmitterChanged(QString, const QString &, QStringList)));
    QDBusConnection::systemBus().connect("com.nokia.csd.Call",
                                         "/com/nokia/csd/call",
                                         "com.nokia.csd.Call",
                                         "Coming",
                                         this, SLOT(callIncoming()));

    QDBusConnection::systemBus().connect("com.nokia.csd.Call",
                                         "/com/nokia/csd/call",
                                         "com.nokia.csd.Call",
                                         "Created",
                                         this, SLOT(callIncoming()));

    button1 = new QPushButton("Enable megaphone", this);
    button1->setGeometry(0, 0, 400, 400);
    connect(button1, SIGNAL(clicked()), this, SLOT(toggleMegaphone()));

    button2 = new QPushButton("Enable FM transmitter", this);
    button2->setGeometry(400, 0, 400, 400);
    connect(button2, SIGNAL(clicked()), this, SLOT(toggleTransmitter()));

}

Widget::~Widget()
{
    if(megaphoneActive) {
       gst_element_set_state(pipeline, GST_STATE_NULL);
       gst_object_unref(pipeline);
    }
}

void Widget::toggleMegaphone()
{
    if(megaphoneActive)
        megaphoneActive = disableMegaphone();
    else
        megaphoneActive = enableMegaphone();

    if(megaphoneActive)
        button1->setText("Disable megaphone");
    else
        button1->setText("Enable megaphone");
}

bool Widget::enableMegaphone()
{
    gst_init(NULL, NULL);

    pipeline = gst_pipeline_new("pipeline");
    GstElement *source, *sink;
    source = gst_element_factory_make("pulsesrc", "source");
    sink = gst_element_factory_make("pulsesink", "sink");

    pa_proplist *proplist = pa_proplist_new();
    pa_proplist_sets(proplist, PA_PROP_EVENT_ID, "ringtone-preview");
    g_object_set(sink, "proplist", proplist, NULL);

    gst_bin_add_many(GST_BIN(pipeline), source, sink, NULL);
    if(!gst_element_link(source, sink))
        return false;

    gst_element_set_state(pipeline, GST_STATE_PLAYING);

    return true;
}

bool Widget::disableMegaphone()
{
    gst_element_set_state(pipeline, GST_STATE_NULL);
    gst_object_unref(pipeline);
    return false;
}

void Widget::enableTransmitter()
{
    QDBusMessage msg = QDBusMessage::createMethodCall("com.nokia.FMTx",
                                                      "/com/nokia/fmtx/default",
                                                      "org.freedesktop.DBus.Properties",
                                                      "Set");

    QVariantList list;
    list.append("com.nokia.FMTx.device");
    list.append("state");
    list.append(QVariant::fromValue(QDBusVariant("enabled")));
    msg.setArguments(list);
    QDBusConnection::systemBus().asyncCall(msg);
}

void Widget::disableTransmitter()
{
    QDBusMessage msg = QDBusMessage::createMethodCall("com.nokia.FMTx",
                                                      "/com/nokia/fmtx/default",
                                                      "org.freedesktop.DBus.Properties",
                                                      "Set");

    QVariantList list;
    list.append("com.nokia.FMTx.device");
    list.append("state");
    list.append(QVariant::fromValue(QDBusVariant("disabled")));
    msg.setArguments(list);
    QDBusConnection::systemBus().asyncCall(msg);
}

void Widget::toggleTransmitter()
{
    if(transmitterActive)
        disableTransmitter();
    else
        enableTransmitter();
}

void Widget::onTransmitterChanged(QString , const QString &msg, QStringList)
{
    transmitterActive = msg.toInt();

    if(transmitterActive)
        button2->setText("Disable FM transmitter");
    else
        button2->setText("Enable FM transmitter");
}

void Widget::callIncoming()
{
    if(megaphoneActive)
    {
        megaphoneActive = disableMegaphone();
        button1->setText("Enable megaphone");
    }
}
