/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/

#include "IMap.h"

#include <QtGui>
#include <projects.h>

#define BASE (0.000013680979338 * DEG_TO_RAD)

const qreal IMap::scales[] =
{
    0.1 * BASE
    ,0.15 * BASE
    ,0.2 * BASE
    ,0.3 * BASE
    ,0.5 * BASE
    ,0.7 * BASE
    ,1.0 * BASE
    ,2.0 * BASE
    ,3.0 * BASE
    ,5.0 * BASE
    ,7.0 * BASE
    ,10.0 * BASE
    ,15.0 * BASE
    ,20.0 * BASE
    ,30.0 * BASE
    ,50.0 * BASE
    ,70.0 * BASE
    ,100.0 * BASE
    ,150.0 * BASE
    ,200.0 * BASE
    ,300.0 * BASE
    ,500.0 * BASE
    ,700.0 * BASE
    ,1500.0 * BASE
    ,2000.0 * BASE
    ,3000.0 * BASE
    ,5000.0 * BASE
    ,7000.0 * BASE
    ,10000.0 * BASE
    ,15000.0 * BASE
    ,20000.0 * BASE
    ,30000.0 * BASE
    ,50000.0 * BASE
    ,60000.0 * BASE
    ,100000.0 * BASE
};
const int IMap::numScales = sizeof(scales) / sizeof(qreal);

IMap::IMap(QObject * parent)
: QObject(parent)
, needsRedraw(true)
{

}


IMap::~IMap()
{

}


void IMap::resize(const QSize& size)
{
    buffer = QPixmap(size);
}


void IMap::draw(QPainter& p)
{
    draw();
    p.drawPixmap(0,0,buffer);
}


void IMap::draw()
{
    buffer.fill(QColor("#ffffcc"));

    QPainter p;
    p.begin(&buffer);
    p.setBrush(Qt::black);
    p.drawText(QRect(0,0,buffer.width(),buffer.height()), Qt::AlignCenter, tr("no map"));
    p.end();
}
