#include "CRollMenu.h"
#include "CCanvas.h"
#include "CWpt.h"
#include "CTrack.h"
#include "CTrackDB.h"
#include "CDlgWptEdit.h"
#include "CDlgTrackEdit.h"

#include <projects.h>
#include <QtGui>

CRollMenu::CRollMenu(QWidget *parent) :
    QWidget(parent)
{
    setupUi(this);
    // Main menu
    connect(menuButton, SIGNAL(clicked(bool)), this, SLOT(slotMenu(bool)));

    //Submenu
    connect(wptButton, SIGNAL(clicked()), this, SLOT(slotWpt()));
    connect(trackButton, SIGNAL(clicked(bool)), this, SLOT(slotTrack(bool)));
    connect(gpsButton, SIGNAL(clicked()), this, SLOT(slotGps()));

    // Track Submenu
    connect(stopButton, SIGNAL(clicked()), this, SLOT(slotTrackStop()));
    connect(recordButton, SIGNAL(clicked()), this, SLOT(slotTrackRecord()));
    connect(pauseButton, SIGNAL(clicked()), this, SLOT(slotTrackPause()));

    recordButton->setEnabled(true);
    pauseButton->setEnabled(false);
    stopButton->setEnabled(false);
    gridLayout->invalidate();
}

CRollMenu::~CRollMenu()
{

}

void CRollMenu::slotMenu(bool bState)
{
    if (bState)
        mainMenu->changeSize(40, 0, QSizePolicy::Minimum, QSizePolicy::Fixed);
    else
        mainMenu->changeSize(40, 0, QSizePolicy::Minimum, QSizePolicy::Expanding);
    // Must call this since it is in separate widget
    gridLayout->invalidate();
}

void CRollMenu::slotWpt()
{
    QSettings cfg;
    QString errmsg;
    qreal lon=0;
    qreal lat=0;
    qreal ele=0;
    CWpt wpt;
    if (CCanvas::self().getCurrentPos(lon , lat, ele) == CCanvas::eLocked)
    {
        wpt.ele = ele;
    }
    wpt.lon = lon * RAD_TO_DEG;
    wpt.lat = lat * RAD_TO_DEG;
    wpt.name = tr("New waypoint");
    wpt.icon = cfg.value("environment/icon", "City (Capitol)").toString();
    CDlgWptEdit *wptEdit = new CDlgWptEdit(wpt,this);
    wptEdit->exec();
    restoreMenu();
}

void CRollMenu::slotGps()
{
    restoreMenu();
}

void CRollMenu::slotTrack(bool bState)
{
    if (bState) {
        trackMenu->changeSize(0, 0, QSizePolicy::Fixed, QSizePolicy::Ignored);
    } else
    {
        trackMenu->changeSize(0, 0, QSizePolicy::Expanding, QSizePolicy::Ignored);
    }
    // Must call this since it is in separate widget
    horizontalLayout->invalidate();
}

void CRollMenu::slotTrackRecord()
{
    CTrack trkpt;
    trkpt.name = tr("New Track");
    trkpt.colorIdx = 0;
    CDlgTrackEdit *trackEdit = new CDlgTrackEdit(trkpt,this);
    trackEdit->exec();
    /// Disable record buton once recording is active
    recordButton->setEnabled(false);
    pauseButton->setEnabled(true);
    stopButton->setEnabled(true);
    restoreMenu();
}

void CRollMenu::slotTrackPause()
{
    if (CTrackDB::self().getState() == CTrackDB::ePause) {
        recordButton->setEnabled(false);
        pauseButton->setEnabled(true);
        stopButton->setEnabled(true);
    } else
    {
        recordButton->setEnabled(false);
        pauseButton->setEnabled(true);
        stopButton->setEnabled(false);
    }
    CTrackDB::self().pause();
    restoreMenu();
}

void CRollMenu::slotTrackStop()
{
    CTrackDB::self().stop();
    recordButton->setEnabled(true);
    pauseButton->setEnabled(false);
    stopButton->setEnabled(false);
    restoreMenu();
}

void CRollMenu::restoreMenu()
{
    trackMenu->changeSize(0, 0, QSizePolicy::Expanding, QSizePolicy::Ignored);
    mainMenu->changeSize(40, 0, QSizePolicy::Minimum, QSizePolicy::Expanding);
    horizontalLayout->invalidate();
    menuButton->setChecked(false);
    trackButton->setChecked(false);
}
