/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#ifndef CMAPWORLD_H
#define CMAPWORLD_H

#include "IMap.h"

class CMapWorld : public IMap
{
    Q_OBJECT;
    public:
        CMapWorld(QObject * parent);
        virtual ~CMapWorld();

        void convertRad2Pt(qreal& x, qreal& y);
        void convertPt2Rad(qreal& x, qreal& y);

    protected:
        void resize(const QSize& s);
        void draw(QPainter& p);
        void move(const QPoint& /*old*/, const QPoint& /*next*/);
        int zoom(int idx);

    private:
        /// the zoom factor derived from the zoom index
        qreal zoomfactor;
        /// the x axis scale of the map [rad/px]
        qreal xscale;
        /// the y axis scale of the map [rad/px]
        qreal yscale;
        /// x left viewport border [rad]
        qreal x;
        /// x top viewport border [rad]
        qreal y;

        /// top left map border in [rad]
        qreal xref1;
        /// top left map border in [rad]
        qreal yref1;
        /// bottom right map border in [rad]
        qreal xref2;
        /// bottom right map border in [rad]
        qreal yref2;

};
#endif                           //CMAPWORLD_H
