/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#ifndef CINFOSCREEN_H
#define CINFOSCREEN_H

#include <QWidget>
#include <QPointer>

#ifdef DISPLAY_NOKIA
#include<ui_IInfoScreen_Nokia.h>
#elif DISPLAY_SMALL
#include<ui_IInfoScreen_small.h>
#else                            //DISPLAY_SMALL
#include<ui_IInfoScreen_large.h>
#endif                           //DISPLAY_SMALL

class CCanvas;
class IGps;

class CInfoScreen : public QWidget, private Ui::IInfoScreen
{
    Q_OBJECT;
    public:
        CInfoScreen(QWidget* parent);
        virtual ~CInfoScreen();

    protected:
        void paintEvent(QPaintEvent * e);
        void draw(QPainter& p);

    protected slots:
        void slotNewGps(IGps * gps);
        void slotNewGpsData(IGps& gps);
        void slotUsrPos(const QPointF& pos, qint32 mode);

};
#endif                           //CINFOSCREEN_H
