/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#ifndef CDLGWPTEDIT_H
#define CDLGWPTEDIT_H

#include <QDialog>

#ifdef DISPLAY_SMALL
#include<ui_IDlgWptEdit_small.h>
#else                            //DISPLAY_SMALL
#include<ui_IDlgWptEdit_large.h>
#endif                           //DISPLAY_SMALL

#include "IKeys.h"

class CWpt;

class CDlgWptEdit : public QDialog, public IKeys, private Ui::IDlgWptEdit
{
    Q_OBJECT;
    public:
        CDlgWptEdit(CWpt& wpt, QWidget * parent);
        virtual ~CDlgWptEdit();

    public slots:
        int exec();

    protected:
        bool eventFilter(QObject *obj, QEvent *event);

    private slots:
        void slotKey1();
        void slotKey2();
        void slotKey3();
        void slotKey4();

        void slotSelectIcon();

        void slotTabChanged(int idx);

    private:
        void showImage(int idx);

    private:
        CWpt& wpt;
        int imgIdx;

};

#endif //CDLGWPTEDIT_H

