/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#include "CDlgSystem.h"
#include "CBacklight.h"
#include "CCanvas.h"

#include <QtGui>

static bool caseLessThan(const QPair<QString, QString> &s1, const QPair<QString, QString> &s2)
{
     return s1.first < s2.first;
}

CDlgSystem::CDlgSystem(QWidget * parent)
: QDialog(parent)
{
    setupUi(this);
    setupKeys(this);
    setWindowFlags(Qt::WindowStaysOnTopHint | Qt::Dialog);
    setAttribute(Qt::WA_DeleteOnClose, false);
    show();

    pushKey1->setText(tr("ok"));
    connect(pushKey1, SIGNAL(clicked()), this, SLOT(slotKey1()));
    pushKey2->setText(tr("cancel"));
    connect(pushKey2, SIGNAL(clicked()), this, SLOT(slotKey2()));
    pushKey3->setText(tr(""));
    connect(pushKey3, SIGNAL(clicked()), this, SLOT(slotKey3()));
    pushKey4->setText(tr(""));
    connect(pushKey4, SIGNAL(clicked()), this, SLOT(slotKey4()));

    comboLight->addItem(tr("manual"), -1);
    comboLight->addItem(tr("15 sec."), 15);
    comboLight->addItem(tr("30 sec."), 30);
    comboLight->addItem(tr("60 sec."), 60);


    int idx = comboLight->findData(CBacklight::self().getTimeout());
    if(idx != -1){
        comboLight->setCurrentIndex(idx);
    }

    sliderBrightness->setValue(CBacklight::self().getBrightness());
    connect(sliderBrightness, SIGNAL(valueChanged(int)), this, SLOT(slotBacklightChanged(int)));

#ifdef WINCE
    comboTimezone->hide();
#else
    // timezone setup
    QList< QPair<QString, QString> > entries;
    QDirIterator it("/usr/share/zoneinfo", QDirIterator::Subdirectories);
    while (it.hasNext()) {
        QFileInfo fi(it.next());
        if(!fi.isFile()) continue;
        entries << QPair<QString, QString>(fi.fileName(), fi.absoluteFilePath());
    }

    qSort(entries.begin(), entries.end(), caseLessThan);

    QPair<QString, QString> entry;
    foreach(entry, entries){
        comboTimezone->addItem(entry.first, entry.second);
    }

    QFileInfo fi("/etc/localtime");
    if(fi.isSymLink()){
        fi = fi.symLinkTarget();
        comboTimezone->setCurrentIndex(comboTimezone->findText(fi.fileName()));
    }

    spacerKeyboard->changeSize(20,0,QSizePolicy::Fixed,QSizePolicy::Fixed);
#endif

    checkLargeIcons->setChecked(CCanvas::self().largeIcons);
}

CDlgSystem::~CDlgSystem()
{

}

void CDlgSystem::slotKey1()
{

#ifdef WINCE

#else
    int idx         = comboTimezone->currentIndex();
    QString path    = comboTimezone->itemData(idx).toString();
    QString cmd     = QString("ln -sf %1 /etc/localtime").arg(path);
    QProcess::execute(cmd);
#endif //WINCE
    CBacklight::self().setTimeout(comboLight->itemData(comboLight->currentIndex()).toInt());
    CBacklight::self().setBrightness(sliderBrightness->value());

    CCanvas::self().largeIcons = checkLargeIcons->isChecked();
    done(0);
}


void CDlgSystem::slotKey2()
{

    done(-1);
}


void CDlgSystem::slotKey3()
{
}


void CDlgSystem::slotKey4()
{
}

void CDlgSystem::slotBacklightChanged(int value )
{
    CBacklight::self().setBrightness(value);
}

