/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#ifndef CDLGGPSSETUP_H
#define CDLGGPSSETUP_H

#include <QDialog>
#include <QProcess>

#ifdef DISPLAY_SMALL
#include<ui_IDlgGpsSetup_small.h>
#else                            //DISPLAY_SMALL
#include<ui_IDlgGpsSetup_large.h>
#endif                           //DISPLAY_SMALL

#include "IKeys.h"

class CDlgGpsSetup : public QDialog, public IKeys, private Ui::IDlgGpsSetup
{
    Q_OBJECT;
    public:
        CDlgGpsSetup(QWidget * parent);
        virtual ~CDlgGpsSetup();

    protected:
        bool eventFilter(QObject *obj, QEvent *event){return IKeys::eventFilter(obj, event);}

    private slots:
        void slotKey1();
        void slotKey2();
        void slotKey3();
        void slotKey4();
        void slotChangeBluetooth(bool on);
        void slotRefresh();
        void slotFinished( int /*exitCode*/, QProcess::ExitStatus /*exitStatus*/ );

    private:
        QProcess * proc;
};
#endif                           //CDLGGPSSETUP_H
