/**********************************************************************************************
    Copyright (C) 2009 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

**********************************************************************************************/
#ifndef CDLGGPS_H
#define CDLGGPS_H

#include <QWidget>
#ifdef DISPLAY_NOKIA
#include<ui_IDlgGps_Nokia.h>
#elif DISPLAY_SMALL
#include<ui_IDlgGps_small.h>
#else                            //DISPLAY_SMALL
#include<ui_IDlgGps_large.h>
#endif                           //DISPLAY_SMALL

class IGps;

class CDlgGps : public QWidget, private Ui::IDlgGps
{
    Q_OBJECT;
    public:
        CDlgGps(QWidget * parent);
        virtual ~CDlgGps();

    protected slots:
        void slotNewGps(IGps * gps);
        void slotNewGpsData(IGps& gps);

    protected:
        void resizeEvent ( QResizeEvent * e );
        QPixmap graph;
};
#endif                           //CDLGGPS_H
