import Qt 4.7

Item {
    id: root

    property variant action: Action { text: "Line Edit" }

    ScreenInfo {
        id: screenInfo
    }

    width: screenInfo.width * 10
    height: screenInfo.height

    Rectangle {
        anchors.fill: parent
        anchors.rightMargin: 1
        anchors.bottomMargin: 1
        radius: screenInfo.unit * 0.2
        border.color: screenInfo.border
        border.width: 1
        color: screenInfo.base

        Item {
            anchors.fill: parent
            anchors.margins: screenInfo.unit * 0.15
            clip: true
            TextInput {
                anchors.fill: parent
                font.pixelSize: screenInfo.fontSize
                color: screenInfo.text

                text: action.text
                onTextChanged: action.text = text
            }
        }
    }
}
