import Qt 4.7

Button {
    id: root
    className: 'CheckBox'

    action: Action { text: "CheckBox"; checkable: true }

    width: screenInfo.width * 10
    height: screenInfo.height

    Rectangle {
        id: check
        anchors.left: parent.left
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.margins: screenInfo.unit * 0.25
        width: height

        color: screenInfo.base
        border.color: screenInfo.background
        border.width: 1
        radius: screenInfo.unit * 0.15

        Text {
            anchors.centerIn: parent
            color: screenInfo.text
            text: '\u2713'
            font.pixelSize: screenInfo.fontSize
            visible: root.action.checked
        }
    }

    Label {
        id: label
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.left: check.right
        anchors.right: parent.right

        anchors.margins: screenInfo.unit * 0.1
        action: root.action
    }

    Connections {
        target: root
        onClicked: {
            action.toggle()
        }
    }
}
