/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *   qimsys                                                                  *
 *   Copyright (C) 2010 by Tasuku Suzuki <stasuku@gmail.com>                 *
 *                                                                           *
 *   This program is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Lesser Public License as          *
 *   published by the Free Software Foundation; either version 2 of the      *
 *   License, or (at your option) any later version.                         *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU Lesser General Public License for more details.                     *
 *                                                                           *
 *   You should have received a copy of the GNU Lesser General Public        *
 *   License along with this program; if not, write to the                   *
 *   Free Software Foundation, Inc.,                                         *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.               *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "languageobject.h"
#include "translator.h"
#include "languagesettings.h"
#include "qimsysdebug.h"

class LanguageObject::Private : private QObject
{
    Q_OBJECT
public:
    Private(LanguageObject *parent);
    ~Private();

private:
    LanguageObject *q;
};

LanguageObject::Private::Private(LanguageObject *parent)
    : QObject(parent)
    , q(parent)
{
    q->setGroups(QStringList() << QLatin1String("X11 Classic"));
    q->setCategoryType(All);
    q->setCategoryName(tr("Settings/Display Language"));

    q->setIcon(QIcon(":/languageicon.png"));
    q->setName(tr("Display language"));
    q->setAuthor(tr("Tasuku Suzuki"));
    q->setDescription(tr("This plugin is used to change display language."));
    q->setTranslator(tr("NONE"));
}

LanguageObject::Private::~Private()
{
}

LanguageObject::LanguageObject(QObject *parent)
    : QimsysAbstractPluginObject(parent)
{
    d = new Private(this);
}

LanguageObject::~LanguageObject()
{
    delete d;
}

QimsysSettingsWidget *LanguageObject::settings(const QString &hint, QWidget *parent)
{
    return new LanguageSettings(this, parent);
}

#include "languageobject.moc"
