import Qt 4.7

Button {
    id: root
    className: 'RadioButton'

    action: Action { text: "Radio Button"; checkable: true }

    width: screenInfo.width * 10
    height: screenInfo.height

    Label {
        id: label
        anchors.fill: parent
        anchors.margins: screenInfo.unit * 0.1
        action: root.action
    }

    StateGroup {
        states: [
            State {
                name: "selected"
                when: root.action.checked
                PropertyChanges {
                    target: root
                    color: screenInfo.highlight
                }
            }
        ]
    }

    Connections {
        target: root
        onClicked: {
            if (!root.action.checked) {
                for (var i = 0; i < root.parent.children.length; i++) {
                    var child = root.parent.children[i]
                    if (typeof child.className != 'undefined' && child.className == root.className) {
                        if (child.action.checked == true) {
                            child.action.toggle()
                            break
                        }
                    }
                }
                root.action.toggle()
            }
        }
    }
}
